/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.AssetBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AssetBaseExchangeListed")
@ImplementedBy(value=Default.class)
public interface AssetBaseExchangeListed
extends Validator<AssetBase> {
    public static final String NAME = "AssetBaseExchangeListed";
    public static final String DEFINITION = "if exchange exists then isExchangeListed";

    public static class NoOp
    implements AssetBaseExchangeListed {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetBase assetBase) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AssetBaseExchangeListed {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetBase assetBase) {
            ComparisonResult result = this.executeDataRule(assetBase);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AssetBaseExchangeListed.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetBase", (RosettaPath)path, (String)AssetBaseExchangeListed.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AssetBaseExchangeListed.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetBase", (RosettaPath)path, (String)AssetBaseExchangeListed.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(AssetBase assetBase) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)assetBase).map("getExchange", _assetBase -> _assetBase.getExchange())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ComparisonResult.of((Mapper)MapperS.of((Object)assetBase).map("getIsExchangeListed", _assetBase -> _assetBase.getIsExchangeListed()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

