/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.functions;

import cdm.base.staticdata.asset.common.AssetIdTypeEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Cash;
import cdm.base.staticdata.asset.common.CurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=SetCashCurrencyDefault.class)
public abstract class SetCashCurrency
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Cash evaluate(Cash cash, CurrencyCodeEnum currency) {
        Cash cashOutput;
        Cash.CashBuilder cashOutputBuilder = this.doEvaluate(cash, currency);
        if (cashOutputBuilder == null) {
            cashOutput = null;
        } else {
            cashOutput = cashOutputBuilder.build();
            this.objectValidator.validate(Cash.class, (RosettaModelObject)cashOutput);
        }
        return cashOutput;
    }

    protected abstract Cash.CashBuilder doEvaluate(Cash var1, CurrencyCodeEnum var2);

    public static class SetCashCurrencyDefault
    extends SetCashCurrency {
        @Override
        protected Cash.CashBuilder doEvaluate(Cash cash, CurrencyCodeEnum currency) {
            Cash.CashBuilder cashOutput = Cash.builder();
            return this.assignOutput(cashOutput, cash, currency);
        }

        protected Cash.CashBuilder assignOutput(Cash.CashBuilder cashOutput, Cash cash, CurrencyCodeEnum currency) {
            AssetIdentifier assetIdentifier = AssetIdentifier.builder().setIdentifierValue((String)MapperS.of((Object)((Object)currency)).map("to-string", CurrencyCodeEnum::toDisplayString).get()).setIdentifierType(AssetIdTypeEnum.CURRENCY_CODE).build();
            cashOutput.setIdentifier(assetIdentifier == null ? Collections.emptyList() : Collections.singletonList(assetIdentifier));
            return Optional.ofNullable(cashOutput).map(o -> o.prune()).orElse(null);
        }
    }
}

