/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.functions.BusinessCenterHolidaysMultiple;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=IsHolidayDefault.class)
public abstract class IsHoliday
implements RosettaFunction {
    @Inject
    protected BusinessCenterHolidaysMultiple businessCenterHolidaysMultiple;

    public Boolean evaluate(Date checkDate, List<BusinessCenterEnum> businessCenters) {
        Boolean isHoliday = this.doEvaluate(checkDate, businessCenters);
        return isHoliday;
    }

    protected abstract Boolean doEvaluate(Date var1, List<BusinessCenterEnum> var2);

    protected abstract MapperC<Date> holidays(Date var1, List<BusinessCenterEnum> var2);

    public static class IsHolidayDefault
    extends IsHoliday {
        @Override
        protected Boolean doEvaluate(Date checkDate, List<BusinessCenterEnum> businessCenters) {
            if (businessCenters == null) {
                businessCenters = Collections.emptyList();
            }
            Boolean isHoliday = null;
            return this.assignOutput(isHoliday, checkDate, businessCenters);
        }

        protected Boolean assignOutput(Boolean isHoliday, Date checkDate, List<BusinessCenterEnum> businessCenters) {
            isHoliday = ExpressionOperators.contains(this.holidays(checkDate, businessCenters), (Mapper)MapperS.of((Object)checkDate)).get();
            return isHoliday;
        }

        @Override
        protected MapperC<Date> holidays(Date checkDate, List<BusinessCenterEnum> businessCenters) {
            return MapperC.of(this.businessCenterHolidaysMultiple.evaluate(businessCenters));
        }
    }
}

