# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['PerformancePayout']

from cdm.product.common.settlement.PayoutBase import PayoutBase

class PerformancePayout(PayoutBase):
    """
    Contains the necessary specifications for all performance payouts, encompassing equity return, dividend, variance, volatility and correlation products. The Performance Payout is either a straight return, or an aggregation of multiple returns, hence a required choice between returnTerms and multiple portfolioReturnTerms.
    """
    observationTerms: Optional[cdm.product.common.schedule.ObservationTerms.ObservationTerms] = Field(None, description="Defines how and when a performance type option or performance type swap is to be observed.")
    """
    Defines how and when a performance type option or performance type swap is to be observed.
    """
    valuationDates: cdm.observable.asset.ValuationDates.ValuationDates = Field(..., description="Defines how and when a performance type option or performance type swap is to be valued, including both interim and final valuation.")
    """
    Defines how and when a performance type option or performance type swap is to be valued, including both interim and final valuation.
    """
    paymentDates: cdm.product.common.schedule.PaymentDates.PaymentDates = Field(..., description="Defines the payment date schedule, as defined by the parameters that are needed to specify it, either in a parametric way or by reference to another schedule of dates (e.g. the valuation dates).")
    """
    Defines the payment date schedule, as defined by the parameters that are needed to specify it, either in a parametric way or by reference to another schedule of dates (e.g. the valuation dates).
    """
    underlier: Optional[cdm.product.template.Product.Product] = Field(None, description="Identifies the underlying product that is referenced for pricing of the applicable leg in a swap. Referenced in the '2018 ISDA CDM Equity Confirmation for Security Equity Swap' as Security.")
    """
    Identifies the underlying product that is referenced for pricing of the applicable leg in a swap.  Referenced in the '2018 ISDA CDM Equity Confirmation for Security Equity Swap' as Security.
    """
    fxFeature: List[cdm.product.template.FxFeature.FxFeature] = Field([], description="Defines quanto or composite FX features that are included in the swap leg.")
    """
    Defines quanto or composite FX features that are included in the swap leg.
    """
    returnTerms: Optional[cdm.product.template.ReturnTerms.ReturnTerms] = Field(None, description="Specifies the type of return of a performance payout.")
    """
    Specifies the type of return of a performance payout.
    """
    portfolioReturnTerms: List[cdm.product.template.PortfolioReturnTerms.PortfolioReturnTerms] = Field([], description="Specifies an individual type of return of a Performance Payout, when such individual return is part of an aggregation of multiple similar returns, at Performance Payout level")
    """
    Specifies an individual type of return of a Performance Payout, when such individual return is part of an aggregation of multiple similar returns, at Performance Payout level
    """
    initialValuationPrice: List[AttributeWithAddress[cdm.observable.asset.PriceSchedule.PriceSchedule] | cdm.observable.asset.PriceSchedule.PriceSchedule] = Field([], description="Specifies the net initial valuation price(s) of the underlier at Performance Payout level. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.")
    """
    Specifies the net initial valuation price(s) of the underlier at Performance Payout level. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.
    """
    interimValuationPrice: List[AttributeWithAddress[cdm.observable.asset.PriceSchedule.PriceSchedule] | cdm.observable.asset.PriceSchedule.PriceSchedule] = Field([], description="Specifies the net initial valuation price(s) of the underlier at Performance Payout level. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.")
    """
    Specifies the net initial valuation price(s) of the underlier at Performance Payout level. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.
    """
    finalValuationPrice: List[AttributeWithAddress[cdm.observable.asset.PriceSchedule.PriceSchedule] | cdm.observable.asset.PriceSchedule.PriceSchedule] = Field([], description="Specifies the net final valuation price(s) of the underlier at Performance Payout level. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.")
    """
    Specifies the net final valuation price(s) of the underlier at Performance Payout level. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.
    """
    
    @rosetta_condition
    def condition_0_PorfolioOrStraightReturn(self):
        item = self
        return rosetta_check_one_of(self, 'returnTerms', 'portfolioReturnTerms', necessity=True)
    
    @rosetta_condition
    def condition_1_PortofolioReturnIsMultipleReturns(self):
        item = self
        def _then_fn0():
            return all_elements(rosetta_count(rosetta_resolve_attr(self, "portfolioReturnTerms")), ">", 1)
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "portfolioReturnTerms")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_UnderlierOfPortfolioIsBasket(self):
        item = self
        def _then_fn0():
            return rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "basket"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "portfolioReturnTerms"), "priceReturnTerms")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_3_Quantity(self):
        """
        When there is an OptionPayout the quantity can be expressed as part of the payoutQuantity, or as part of the underlier in the case of a Swaption.  For all other payouts that extend PayoutBase the payoutQuantity is a mandatory attribute.
        """
        item = self
        return rosetta_attr_exists(rosetta_resolve_attr(self, "priceQuantity"))
    
    @rosetta_condition
    def condition_4_NoSharePriceDividendAdjustmentIndex(self):
        """
        If the underlier is an index, sharePriceAdjustment and sharePriceDividendAdjustment cannot exist.
        """
        item = self
        def _then_fn0():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "varianceReturnTerms"), "sharePriceDividendAdjustment"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "volatilityReturnTerms"), "sharePriceDividendAdjustment"))))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "index")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_5_NoSharePriceDividendAdjustmentForeignExchange(self):
        """
        If the underlier is an foreign exchange, sharePriceAdjustment and sharePriceDividendAdjustment cannot exist.
        """
        item = self
        def _then_fn0():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "varianceReturnTerms"), "sharePriceDividendAdjustment"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "volatilityReturnTerms"), "sharePriceDividendAdjustment"))))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "foreignExchange")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_6_CorrelationUnderlierOnlyBasket(self):
        """
        Correlation Return Terms can only have a basket as underlier, since it needs to compute the correlation between two or more products.
        """
        item = self
        def _then_fn0():
            return rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "basket"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "correlationReturnTerms")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_7_EquitySpecificAttributes(self):
        """
        Equity specific attributes cannot be present in non-equity products.
        """
        item = self
        def _then_fn0():
            return (((((((((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "varianceReturnTerms"), "dividendApplicability"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "varianceReturnTerms"), "equityUnderlierProvisions")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "varianceReturnTerms"), "sharePriceDividendAdjustment")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "volatilityReturnTerms"), "dividendApplicability")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "volatilityReturnTerms"), "equityUnderlierProvisions")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "volatilityReturnTerms"), "sharePriceDividendAdjustment")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "correlationReturnTerms"), "dividendApplicability")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "correlationReturnTerms"), "equityUnderlierProvisions")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "returnTerms"), "correlationReturnTerms"), "sharePriceDividendAdjustment"))))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(Qualify_UnderlierProduct_Equity(rosetta_resolve_attr(self, "underlier")), "=", False), _then_fn0, _else_fn0)

import cdm 
import cdm.product.common.schedule.ObservationTerms
import cdm.observable.asset.ValuationDates
import cdm.product.common.schedule.PaymentDates
import cdm.product.template.Product
import cdm.product.template.FxFeature
import cdm.product.template.ReturnTerms
import cdm.product.template.PortfolioReturnTerms
import cdm.observable.asset.PriceSchedule
from cdm.product.qualification.functions.Qualify_UnderlierProduct_Equity import Qualify_UnderlierProduct_Equity
