# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['EconomicTerms']


class EconomicTerms(BaseDataClass):
    """
     This class represents the full set of price-forming features associated with a contractual product: the payout component, the notional/quantity, the effective and termination date and the date adjustment provisions when applying uniformily across the payout components. This class also includes the legal provisions which have valuation implications: cancelable provision, extendible provision, early termination provision and extraordinary events specification.
    """
    effectiveDate: Optional[cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDate] = Field(None, description="The first day of the terms of the trade. This day may be subject to adjustment in accordance with a business day convention.")
    """
    The first day of the terms of the trade. This day may be subject to adjustment in accordance with a business day convention.
    """
    terminationDate: Optional[cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDate] = Field(None, description="The last day of the terms of the trade. This date may be subject to adjustments in accordance with the business day convention. It can also be specified in relation to another scheduled date (e.g. the last payment date).")
    """
    The last day of the terms of the trade. This date may be subject to adjustments in accordance with the business day convention. It can also be specified in relation to another scheduled date (e.g. the last payment date).
    """
    dateAdjustments: Optional[cdm.base.datetime.BusinessDayAdjustments.BusinessDayAdjustments] = Field(None, description="The business day adjustment convention when it applies across all the payout components. This specification of the business day convention and financial business centers is used for adjusting any calculation period date if it would otherwise fall on a day that is not a business day in the specified business center.")
    """
    The business day adjustment convention when it applies across all the payout components. This specification of the business day convention and financial business centers is used for adjusting any calculation period date if it would otherwise fall on a day that is not a business day in the specified business center.
    """
    payout: cdm.product.template.Payout.Payout = Field(..., description="The payout specifies the future cashflow computation methodology which characterizes a financial product.")
    """
    The payout specifies the future cashflow computation methodology which characterizes a financial product.
    """
    terminationProvision: Optional[cdm.product.template.TerminationProvision.TerminationProvision] = Field(None, description="Contains optional provisions pertaining to the termination characteristics of a contract.")
    """
    Contains optional provisions pertaining to the termination characteristics of a contract.
    """
    calculationAgent: Optional[cdm.observable.asset.CalculationAgent.CalculationAgent] = Field(None, description="The ISDA calculation agent responsible for performing duties as defined in the applicable product definitions.")
    """
    The ISDA calculation agent responsible for performing duties as defined in the applicable product definitions.
    """
    nonStandardisedTerms: Optional[bool] = Field(None, description="Specifies, when boolean value is True, that additional economic terms exist that have not been included in the product representation.")
    """
    Specifies, when boolean value is True, that additional economic terms exist that have not been included in the product representation.
    """
    collateral: Optional[cdm.product.collateral.Collateral.Collateral] = Field(None, description="Represents the collateral obligations of a party.")
    """
    Represents the collateral obligations of a party.
    """
    
    @rosetta_condition
    def condition_0_FpML_cd_26_28(self):
        """
        FpML validation rule cd-26 - If feeLeg/singlePayment/adjustablePaymentDate exists, then feeLeg/singlePayment/adjustablePaymentDate must be after generalTerms/effectiveDate/unadjustedDate. FpML validation rule cd-28 - If feeLeg/periodicPayment/firstPaymentDate exists, then feeLeg/periodicPayment/firstPaymentDate must be after generalTerms/effectiveDate/unadjustedDate. This data rule tackles those two FpML validation rules at once, as the singlePayment and the firstPayment have been represented through the same Payout/cashflow attribute.
        """
        item = self
        def _then_fn0():
            return ((all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"), "unadjustedDate"), ">", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "effectiveDate"), "adjustableDate"), "unadjustedDate")) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"), "adjustedDate"), ">", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "effectiveDate"), "adjustableDate"), "adjustedDate"))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"), "relativeDate"), "adjustedDate"), ">", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "effectiveDate"), "relativeDate"), "adjustedDate")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(((((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "creditDefaultPayout")) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow"))) and rosetta_attr_exists(rosetta_resolve_attr(self, "effectiveDate"))) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"), "unadjustedDate"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"), "relativeDate")))), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_FpML_cd_27(self):
        """
        FpML validation rule cd-27 - If feeLeg/singlePayment/adjustablePaymentDate exists, and if generalTerms/scheduledTerminationDate exists, then feeLeg/singlePayment/adjustablePaymentDate must be before generalTerms/scheduledTerminationDate/unadjustedDate.
        """
        item = self
        def _then_fn0():
            return ((all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"), "unadjustedDate"), "<", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationDate"), "adjustableDate"), "unadjustedDate")) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"), "adjustedDate"), "<", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationDate"), "adjustableDate"), "adjustedDate"))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"), "relativeDate"), "adjustedDate"), "<", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationDate"), "adjustableDate"), "adjustedDate")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "creditDefaultPayout")) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow"))) and rosetta_attr_exists(rosetta_resolve_attr(self, "terminationDate"))) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"))), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_FpML_cd_30(self):
        """
        FpML validation rule cd-30 - If feeLeg/periodicPayment/lastRegularPaymentDate exists, and if generalTerms/scheduledTerminationDate exists, then feeLeg/periodicPayment/lastRegularPaymentDate must be before generalTerms/scheduledTerminationDate/unadjustedDate.
        """
        item = self
        def _then_fn0():
            return (all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "interestRatePayout"), "paymentDates"), "lastRegularPaymentDate"), "<", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationDate"), "adjustableDate"), "unadjustedDate")) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "interestRatePayout"), "paymentDates"), "lastRegularPaymentDate"), "<", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationDate"), "adjustableDate"), "adjustedDate")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "interestRatePayout"), "paymentDates"), "lastRegularPaymentDate")) and rosetta_attr_exists(rosetta_resolve_attr(self, "terminationDate"))), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_3_IndependentCalculationAgent(self):
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "calculationAgent"), "calculationAgentParty"), "=", rosetta_resolve_attr(AncillaryRoleEnum, "CALCULATION_AGENT_INDEPENDENT"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "calculationAgent"), "calculationAgentParty")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_4_AssetPayoutDividendTermsValidation(self):
        """
        Validates that if the transaction has Dividend Terms specified then it should be a Term trade.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "terminationDate"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "assetPayout"), "dividendTerms")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_5_ExtendibleProvisionExerciseDetails(self):
        """
        Ensure that the correct details are specified for an extendible contract.
        """
        item = self
        def _then_fn1():
            return ((((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationProvision"), "extendibleProvision"), "americanExercise")) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationProvision"), "extendibleProvision"), "bermudaExercise")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationProvision"), "extendibleProvision"), "europeanExercise")))) or (((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationProvision"), "extendibleProvision"), "americanExercise"))) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationProvision"), "extendibleProvision"), "bermudaExercise"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationProvision"), "extendibleProvision"), "europeanExercise"))))) or ((((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationProvision"), "extendibleProvision"), "americanExercise"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationProvision"), "extendibleProvision"), "bermudaExercise")))) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationProvision"), "extendibleProvision"), "europeanExercise"))) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationProvision"), "extendibleProvision"), "followUpConfirmation"))))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationProvision"), "extendibleProvision")), _then_fn1, _else_fn1)
        
        def _else_fn0():
            return True
        
        return if_cond_fn((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "assetPayout"))), _then_fn0, _else_fn0)

import cdm 
import cdm.base.datetime.AdjustableOrRelativeDate
import cdm.base.datetime.BusinessDayAdjustments
import cdm.product.template.Payout
import cdm.product.template.TerminationProvision
import cdm.observable.asset.CalculationAgent
import cdm.product.collateral.Collateral
from cdm.base.staticdata.party.AncillaryRoleEnum import AncillaryRoleEnum
