# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ContractualProduct']

from cdm.base.staticdata.asset.common.ProductBase import ProductBase

class ContractualProduct(ProductBase):
    """
     A class to specify the contractual products' economic terms, alongside their product identification and product taxonomy. The contractual product class is meant to be used across the pre-execution, execution and (as part of the Contract) post-execution lifecycle contexts.
    """
    economicTerms: cdm.product.template.EconomicTerms.EconomicTerms = Field(..., description="The economic terms associated with a contractual product, i.e. the set of features that are price-forming.")
    """
    The economic terms associated with a contractual product, i.e. the set of features that are price-forming.
    """
    
    @rosetta_condition
    def condition_0_PrimaryAssetClass(self):
        """
        Specifies that when nonStandardisedTerms are True that a primary asset class must be specified.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "productTaxonomy"), "primaryAssetClass"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "nonStandardisedTerms"), "=", True), _then_fn0, _else_fn0)

import cdm 
import cdm.product.template.EconomicTerms
