# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CalculationAgentModel']


class CalculationAgentModel(BaseDataClass):
    """
    This class corresponds to the FpML CalculationAgent.model.
    """
    calculationAgent: Optional[cdm.observable.asset.CalculationAgent.CalculationAgent] = Field(None, description="The ISDA calculation agent responsible for performing duties as defined in the applicable product definitions.")
    """
    The ISDA calculation agent responsible for performing duties as defined in the applicable product definitions.
    """
    calculationAgentBusinessCenter: Optional[cdm.base.datetime.BusinessCenterEnum.BusinessCenterEnum] = Field(None, description="The city in which the office through which ISDA Calculation Agent is acting for purposes of the transaction is located. The short-form confirm for a trade that is executed under a Sovereign or Asia-Pacific Master Confirmation Agreement (MCA), does not need to specify the Calculation Agent. However, the confirm does need to specify the Calculation Agent city. This is due to the fact that the MCA sets the value for Calculation Agent but does not set the value for Calculation Agent city.")
    """
    The city in which the office through which ISDA Calculation Agent is acting for purposes of the transaction is located. The short-form confirm for a trade that is executed under a Sovereign or Asia-Pacific Master Confirmation Agreement (MCA), does not need to specify the Calculation Agent. However, the confirm does need to specify the Calculation Agent city. This is due to the fact that the MCA sets the value for Calculation Agent but does not set the value for Calculation Agent city.
    """

import cdm 
import cdm.observable.asset.CalculationAgent
import cdm.base.datetime.BusinessCenterEnum
