# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.collateral.functions.MergeEligibleCollateralCriteria import MergeEligibleCollateralCriteria
from cdm.product.collateral.EligibleCollateralSpecificationInstruction import EligibleCollateralSpecificationInstruction
from cdm.product.collateral.EligibleCollateralSpecification import EligibleCollateralSpecification

__all__ = ['Create_EligibleCollateralSpecificationFromInstruction']


@replaceable
def Create_EligibleCollateralSpecificationFromInstruction(instruction: EligibleCollateralSpecificationInstruction) -> EligibleCollateralSpecification:
    """
    Creates an Eligible Collateral Specification through the combination of common and variable characteristics.
    
    Parameters 
    ----------
    instruction : EligibleCollateralSpecificationInstruction
    
    Returns
    -------
    specification : EligibleCollateralSpecification
    
    """
    self = inspect.currentframe()
    
    
    specification = list(map(lambda item: MergeEligibleCollateralCriteria(item, rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "common")), rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "variable")))
    
    
    return specification

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
