/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PayoutMarketPrice")
@ImplementedBy(value=Default.class)
public interface PayoutMarketPrice
extends Validator<Payout> {
    public static final String NAME = "PayoutMarketPrice";
    public static final String DEFINITION = "if creditDefaultPayout -> generalTerms -> indexReferenceInformation is absent then creditDefaultPayout -> transactedPrice -> marketFixedRate is absent and creditDefaultPayout -> transactedPrice -> marketPrice is absent";

    public static class NoOp
    implements PayoutMarketPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Payout payout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PayoutMarketPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Payout payout) {
            ComparisonResult result = this.executeDataRule(payout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PayoutMarketPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutMarketPrice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PayoutMarketPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutMarketPrice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Payout payout) {
            try {
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)payout).map("getCreditDefaultPayout", _payout -> _payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)payout).map("getCreditDefaultPayout", _payout -> _payout.getCreditDefaultPayout()).map("getTransactedPrice", creditDefaultPayout -> creditDefaultPayout.getTransactedPrice()).map("getMarketFixedRate", transactedPrice -> transactedPrice.getMarketFixedRate())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)payout).map("getCreditDefaultPayout", _payout -> _payout.getCreditDefaultPayout()).map("getTransactedPrice", creditDefaultPayout -> creditDefaultPayout.getTransactedPrice()).map("getMarketPrice", transactedPrice -> transactedPrice.getMarketPrice())));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

