/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.staticdata.asset.common.AssetType;
import cdm.base.staticdata.asset.common.CollateralIssuerType;
import cdm.base.staticdata.asset.common.CurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.party.LegalEntity;
import cdm.product.collateral.AgencyRatingCriteria;
import cdm.product.collateral.meta.EligibilityQueryMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EligibilityQuery", builder=EligibilityQueryBuilderImpl.class, version="5.28.0")
@RuneDataType(value="EligibilityQuery", model="cdm", builder=EligibilityQueryBuilderImpl.class, version="5.28.0")
public interface EligibilityQuery
extends RosettaModelObject {
    public static final EligibilityQueryMeta metaData = new EligibilityQueryMeta();

    public BigDecimal getMaturity();

    public AssetType getCollateralAssetType();

    public ISOCountryCodeEnum getAssetCountryOfOrigin();

    public CurrencyCodeEnum getDenominatedCurrency();

    public AgencyRatingCriteria getAgencyRating();

    public CollateralIssuerType getIssuerType();

    public LegalEntity getIssuerName();

    public EligibilityQuery build();

    public EligibilityQueryBuilder toBuilder();

    public static EligibilityQueryBuilder builder() {
        return new EligibilityQueryBuilderImpl();
    }

    default public RosettaMetaData<? extends EligibilityQuery> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EligibilityQuery> getType() {
        return EligibilityQuery.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("maturity"), BigDecimal.class, (Object)this.getMaturity(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralAssetType"), processor, AssetType.class, this.getCollateralAssetType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetCountryOfOrigin"), ISOCountryCodeEnum.class, (Object)this.getAssetCountryOfOrigin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("denominatedCurrency"), CurrencyCodeEnum.class, (Object)this.getDenominatedCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agencyRating"), processor, AgencyRatingCriteria.class, this.getAgencyRating(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerType"), processor, CollateralIssuerType.class, this.getIssuerType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerName"), processor, LegalEntity.class, this.getIssuerName(), new AttributeMeta[0]);
    }

    public static class EligibilityQueryBuilderImpl
    implements EligibilityQueryBuilder {
        protected BigDecimal maturity;
        protected AssetType.AssetTypeBuilder collateralAssetType;
        protected ISOCountryCodeEnum assetCountryOfOrigin;
        protected CurrencyCodeEnum denominatedCurrency;
        protected AgencyRatingCriteria.AgencyRatingCriteriaBuilder agencyRating;
        protected CollateralIssuerType.CollateralIssuerTypeBuilder issuerType;
        protected LegalEntity.LegalEntityBuilder issuerName;

        @Override
        @RosettaAttribute(value="maturity", isRequired=true)
        @RuneAttribute(value="maturity", isRequired=true)
        public BigDecimal getMaturity() {
            return this.maturity;
        }

        @Override
        @RosettaAttribute(value="collateralAssetType", isRequired=true)
        @RuneAttribute(value="collateralAssetType", isRequired=true)
        public AssetType.AssetTypeBuilder getCollateralAssetType() {
            return this.collateralAssetType;
        }

        @Override
        public AssetType.AssetTypeBuilder getOrCreateCollateralAssetType() {
            AssetType.AssetTypeBuilder result = this.collateralAssetType != null ? this.collateralAssetType : (this.collateralAssetType = AssetType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="assetCountryOfOrigin", isRequired=true)
        @RuneAttribute(value="assetCountryOfOrigin", isRequired=true)
        public ISOCountryCodeEnum getAssetCountryOfOrigin() {
            return this.assetCountryOfOrigin;
        }

        @Override
        @RosettaAttribute(value="denominatedCurrency", isRequired=true)
        @RuneAttribute(value="denominatedCurrency", isRequired=true)
        public CurrencyCodeEnum getDenominatedCurrency() {
            return this.denominatedCurrency;
        }

        @Override
        @RosettaAttribute(value="agencyRating", isRequired=true)
        @RuneAttribute(value="agencyRating", isRequired=true)
        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getAgencyRating() {
            return this.agencyRating;
        }

        @Override
        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateAgencyRating() {
            AgencyRatingCriteria.AgencyRatingCriteriaBuilder result = this.agencyRating != null ? this.agencyRating : (this.agencyRating = AgencyRatingCriteria.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="issuerType", isRequired=true)
        @RuneAttribute(value="issuerType", isRequired=true)
        public CollateralIssuerType.CollateralIssuerTypeBuilder getIssuerType() {
            return this.issuerType;
        }

        @Override
        public CollateralIssuerType.CollateralIssuerTypeBuilder getOrCreateIssuerType() {
            CollateralIssuerType.CollateralIssuerTypeBuilder result = this.issuerType != null ? this.issuerType : (this.issuerType = CollateralIssuerType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="issuerName", isRequired=true)
        @RuneAttribute(value="issuerName", isRequired=true)
        public LegalEntity.LegalEntityBuilder getIssuerName() {
            return this.issuerName;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateIssuerName() {
            LegalEntity.LegalEntityBuilder result = this.issuerName != null ? this.issuerName : (this.issuerName = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="maturity", isRequired=true)
        @RuneAttribute(value="maturity", isRequired=true)
        public EligibilityQueryBuilder setMaturity(BigDecimal _maturity) {
            this.maturity = _maturity == null ? null : _maturity;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralAssetType", isRequired=true)
        @RuneAttribute(value="collateralAssetType", isRequired=true)
        public EligibilityQueryBuilder setCollateralAssetType(AssetType _collateralAssetType) {
            this.collateralAssetType = _collateralAssetType == null ? null : _collateralAssetType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetCountryOfOrigin", isRequired=true)
        @RuneAttribute(value="assetCountryOfOrigin", isRequired=true)
        public EligibilityQueryBuilder setAssetCountryOfOrigin(ISOCountryCodeEnum _assetCountryOfOrigin) {
            this.assetCountryOfOrigin = _assetCountryOfOrigin == null ? null : _assetCountryOfOrigin;
            return this;
        }

        @Override
        @RosettaAttribute(value="denominatedCurrency", isRequired=true)
        @RuneAttribute(value="denominatedCurrency", isRequired=true)
        public EligibilityQueryBuilder setDenominatedCurrency(CurrencyCodeEnum _denominatedCurrency) {
            this.denominatedCurrency = _denominatedCurrency == null ? null : _denominatedCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="agencyRating", isRequired=true)
        @RuneAttribute(value="agencyRating", isRequired=true)
        public EligibilityQueryBuilder setAgencyRating(AgencyRatingCriteria _agencyRating) {
            this.agencyRating = _agencyRating == null ? null : _agencyRating.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="issuerType", isRequired=true)
        @RuneAttribute(value="issuerType", isRequired=true)
        public EligibilityQueryBuilder setIssuerType(CollateralIssuerType _issuerType) {
            this.issuerType = _issuerType == null ? null : _issuerType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="issuerName", isRequired=true)
        @RuneAttribute(value="issuerName", isRequired=true)
        public EligibilityQueryBuilder setIssuerName(LegalEntity _issuerName) {
            this.issuerName = _issuerName == null ? null : _issuerName.toBuilder();
            return this;
        }

        @Override
        public EligibilityQuery build() {
            return new EligibilityQueryImpl(this);
        }

        @Override
        public EligibilityQueryBuilder toBuilder() {
            return this;
        }

        @Override
        public EligibilityQueryBuilder prune() {
            if (this.collateralAssetType != null && !this.collateralAssetType.prune().hasData()) {
                this.collateralAssetType = null;
            }
            if (this.agencyRating != null && !this.agencyRating.prune().hasData()) {
                this.agencyRating = null;
            }
            if (this.issuerType != null && !this.issuerType.prune().hasData()) {
                this.issuerType = null;
            }
            if (this.issuerName != null && !this.issuerName.prune().hasData()) {
                this.issuerName = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getMaturity() != null) {
                return true;
            }
            if (this.getCollateralAssetType() != null && this.getCollateralAssetType().hasData()) {
                return true;
            }
            if (this.getAssetCountryOfOrigin() != null) {
                return true;
            }
            if (this.getDenominatedCurrency() != null) {
                return true;
            }
            if (this.getAgencyRating() != null && this.getAgencyRating().hasData()) {
                return true;
            }
            if (this.getIssuerType() != null && this.getIssuerType().hasData()) {
                return true;
            }
            return this.getIssuerName() != null && this.getIssuerName().hasData();
        }

        public EligibilityQueryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EligibilityQueryBuilder o = (EligibilityQueryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralAssetType(), (RosettaModelObjectBuilder)o.getCollateralAssetType(), this::setCollateralAssetType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgencyRating(), (RosettaModelObjectBuilder)o.getAgencyRating(), this::setAgencyRating);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuerType(), (RosettaModelObjectBuilder)o.getIssuerType(), this::setIssuerType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuerName(), (RosettaModelObjectBuilder)o.getIssuerName(), this::setIssuerName);
            merger.mergeBasic((Object)this.getMaturity(), (Object)o.getMaturity(), this::setMaturity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAssetCountryOfOrigin(), (Object)o.getAssetCountryOfOrigin(), this::setAssetCountryOfOrigin, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDenominatedCurrency(), (Object)o.getDenominatedCurrency(), this::setDenominatedCurrency, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EligibilityQuery _that = this.getType().cast(o);
            if (!Objects.equals(this.maturity, _that.getMaturity())) {
                return false;
            }
            if (!Objects.equals(this.collateralAssetType, _that.getCollateralAssetType())) {
                return false;
            }
            if (!Objects.equals((Object)this.assetCountryOfOrigin, (Object)_that.getAssetCountryOfOrigin())) {
                return false;
            }
            if (!Objects.equals((Object)this.denominatedCurrency, (Object)_that.getDenominatedCurrency())) {
                return false;
            }
            if (!Objects.equals(this.agencyRating, _that.getAgencyRating())) {
                return false;
            }
            if (!Objects.equals(this.issuerType, _that.getIssuerType())) {
                return false;
            }
            return Objects.equals(this.issuerName, _that.getIssuerName());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.maturity != null ? this.maturity.hashCode() : 0);
            _result = 31 * _result + (this.collateralAssetType != null ? this.collateralAssetType.hashCode() : 0);
            _result = 31 * _result + (this.assetCountryOfOrigin != null ? ((Object)((Object)this.assetCountryOfOrigin)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.denominatedCurrency != null ? ((Object)((Object)this.denominatedCurrency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.agencyRating != null ? this.agencyRating.hashCode() : 0);
            _result = 31 * _result + (this.issuerType != null ? this.issuerType.hashCode() : 0);
            _result = 31 * _result + (this.issuerName != null ? this.issuerName.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EligibilityQueryBuilder {maturity=" + this.maturity + ", collateralAssetType=" + this.collateralAssetType + ", assetCountryOfOrigin=" + (Object)((Object)this.assetCountryOfOrigin) + ", denominatedCurrency=" + (Object)((Object)this.denominatedCurrency) + ", agencyRating=" + this.agencyRating + ", issuerType=" + this.issuerType + ", issuerName=" + this.issuerName + '}';
        }
    }

    public static interface EligibilityQueryBuilder
    extends EligibilityQuery,
    RosettaModelObjectBuilder {
        public AssetType.AssetTypeBuilder getOrCreateCollateralAssetType();

        @Override
        public AssetType.AssetTypeBuilder getCollateralAssetType();

        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateAgencyRating();

        @Override
        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getAgencyRating();

        public CollateralIssuerType.CollateralIssuerTypeBuilder getOrCreateIssuerType();

        @Override
        public CollateralIssuerType.CollateralIssuerTypeBuilder getIssuerType();

        public LegalEntity.LegalEntityBuilder getOrCreateIssuerName();

        @Override
        public LegalEntity.LegalEntityBuilder getIssuerName();

        public EligibilityQueryBuilder setMaturity(BigDecimal var1);

        public EligibilityQueryBuilder setCollateralAssetType(AssetType var1);

        public EligibilityQueryBuilder setAssetCountryOfOrigin(ISOCountryCodeEnum var1);

        public EligibilityQueryBuilder setDenominatedCurrency(CurrencyCodeEnum var1);

        public EligibilityQueryBuilder setAgencyRating(AgencyRatingCriteria var1);

        public EligibilityQueryBuilder setIssuerType(CollateralIssuerType var1);

        public EligibilityQueryBuilder setIssuerName(LegalEntity var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("maturity"), BigDecimal.class, (Object)this.getMaturity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralAssetType"), processor, AssetType.AssetTypeBuilder.class, this.getCollateralAssetType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetCountryOfOrigin"), ISOCountryCodeEnum.class, (Object)this.getAssetCountryOfOrigin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("denominatedCurrency"), CurrencyCodeEnum.class, (Object)this.getDenominatedCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agencyRating"), processor, AgencyRatingCriteria.AgencyRatingCriteriaBuilder.class, this.getAgencyRating(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerType"), processor, CollateralIssuerType.CollateralIssuerTypeBuilder.class, this.getIssuerType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerName"), processor, LegalEntity.LegalEntityBuilder.class, this.getIssuerName(), new AttributeMeta[0]);
        }

        public EligibilityQueryBuilder prune();
    }

    public static class EligibilityQueryImpl
    implements EligibilityQuery {
        private final BigDecimal maturity;
        private final AssetType collateralAssetType;
        private final ISOCountryCodeEnum assetCountryOfOrigin;
        private final CurrencyCodeEnum denominatedCurrency;
        private final AgencyRatingCriteria agencyRating;
        private final CollateralIssuerType issuerType;
        private final LegalEntity issuerName;

        protected EligibilityQueryImpl(EligibilityQueryBuilder builder) {
            this.maturity = builder.getMaturity();
            this.collateralAssetType = Optional.ofNullable(builder.getCollateralAssetType()).map(f -> f.build()).orElse(null);
            this.assetCountryOfOrigin = builder.getAssetCountryOfOrigin();
            this.denominatedCurrency = builder.getDenominatedCurrency();
            this.agencyRating = Optional.ofNullable(builder.getAgencyRating()).map(f -> f.build()).orElse(null);
            this.issuerType = Optional.ofNullable(builder.getIssuerType()).map(f -> f.build()).orElse(null);
            this.issuerName = Optional.ofNullable(builder.getIssuerName()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="maturity", isRequired=true)
        @RuneAttribute(value="maturity", isRequired=true)
        public BigDecimal getMaturity() {
            return this.maturity;
        }

        @Override
        @RosettaAttribute(value="collateralAssetType", isRequired=true)
        @RuneAttribute(value="collateralAssetType", isRequired=true)
        public AssetType getCollateralAssetType() {
            return this.collateralAssetType;
        }

        @Override
        @RosettaAttribute(value="assetCountryOfOrigin", isRequired=true)
        @RuneAttribute(value="assetCountryOfOrigin", isRequired=true)
        public ISOCountryCodeEnum getAssetCountryOfOrigin() {
            return this.assetCountryOfOrigin;
        }

        @Override
        @RosettaAttribute(value="denominatedCurrency", isRequired=true)
        @RuneAttribute(value="denominatedCurrency", isRequired=true)
        public CurrencyCodeEnum getDenominatedCurrency() {
            return this.denominatedCurrency;
        }

        @Override
        @RosettaAttribute(value="agencyRating", isRequired=true)
        @RuneAttribute(value="agencyRating", isRequired=true)
        public AgencyRatingCriteria getAgencyRating() {
            return this.agencyRating;
        }

        @Override
        @RosettaAttribute(value="issuerType", isRequired=true)
        @RuneAttribute(value="issuerType", isRequired=true)
        public CollateralIssuerType getIssuerType() {
            return this.issuerType;
        }

        @Override
        @RosettaAttribute(value="issuerName", isRequired=true)
        @RuneAttribute(value="issuerName", isRequired=true)
        public LegalEntity getIssuerName() {
            return this.issuerName;
        }

        @Override
        public EligibilityQuery build() {
            return this;
        }

        @Override
        public EligibilityQueryBuilder toBuilder() {
            EligibilityQueryBuilder builder = EligibilityQuery.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EligibilityQueryBuilder builder) {
            Optional.ofNullable(this.getMaturity()).ifPresent(builder::setMaturity);
            Optional.ofNullable(this.getCollateralAssetType()).ifPresent(builder::setCollateralAssetType);
            Optional.ofNullable(this.getAssetCountryOfOrigin()).ifPresent(builder::setAssetCountryOfOrigin);
            Optional.ofNullable(this.getDenominatedCurrency()).ifPresent(builder::setDenominatedCurrency);
            Optional.ofNullable(this.getAgencyRating()).ifPresent(builder::setAgencyRating);
            Optional.ofNullable(this.getIssuerType()).ifPresent(builder::setIssuerType);
            Optional.ofNullable(this.getIssuerName()).ifPresent(builder::setIssuerName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EligibilityQuery _that = this.getType().cast(o);
            if (!Objects.equals(this.maturity, _that.getMaturity())) {
                return false;
            }
            if (!Objects.equals(this.collateralAssetType, _that.getCollateralAssetType())) {
                return false;
            }
            if (!Objects.equals((Object)this.assetCountryOfOrigin, (Object)_that.getAssetCountryOfOrigin())) {
                return false;
            }
            if (!Objects.equals((Object)this.denominatedCurrency, (Object)_that.getDenominatedCurrency())) {
                return false;
            }
            if (!Objects.equals(this.agencyRating, _that.getAgencyRating())) {
                return false;
            }
            if (!Objects.equals(this.issuerType, _that.getIssuerType())) {
                return false;
            }
            return Objects.equals(this.issuerName, _that.getIssuerName());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.maturity != null ? this.maturity.hashCode() : 0);
            _result = 31 * _result + (this.collateralAssetType != null ? this.collateralAssetType.hashCode() : 0);
            _result = 31 * _result + (this.assetCountryOfOrigin != null ? ((Object)((Object)this.assetCountryOfOrigin)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.denominatedCurrency != null ? ((Object)((Object)this.denominatedCurrency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.agencyRating != null ? this.agencyRating.hashCode() : 0);
            _result = 31 * _result + (this.issuerType != null ? this.issuerType.hashCode() : 0);
            _result = 31 * _result + (this.issuerName != null ? this.issuerName.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EligibilityQuery {maturity=" + this.maturity + ", collateralAssetType=" + this.collateralAssetType + ", assetCountryOfOrigin=" + (Object)((Object)this.assetCountryOfOrigin) + ", denominatedCurrency=" + (Object)((Object)this.denominatedCurrency) + ", agencyRating=" + this.agencyRating + ", issuerType=" + this.issuerType + ", issuerName=" + this.issuerName + '}';
        }
    }
}

