/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.daycount.metafields.FieldWithMetaDayCountFractionEnum;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.asset.BondReference;
import cdm.product.asset.CashflowRepresentation;
import cdm.product.asset.CompoundingMethodEnum;
import cdm.product.asset.DiscountingMethod;
import cdm.product.asset.RateSpecification;
import cdm.product.asset.SpreadCalculationMethodEnum;
import cdm.product.asset.meta.InterestRatePayoutMeta;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.common.schedule.ResetDates;
import cdm.product.common.schedule.StubPeriod;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="InterestRatePayout", builder=InterestRatePayoutBuilderImpl.class, version="5.28.0")
@RuneDataType(value="InterestRatePayout", model="cdm", builder=InterestRatePayoutBuilderImpl.class, version="5.28.0")
public interface InterestRatePayout
extends PayoutBase,
GlobalKey {
    public static final InterestRatePayoutMeta metaData = new InterestRatePayoutMeta();

    public RateSpecification getRateSpecification();

    public FieldWithMetaDayCountFractionEnum getDayCountFraction();

    public CalculationPeriodDates getCalculationPeriodDates();

    public PaymentDates getPaymentDates();

    public AdjustableDate getPaymentDate();

    public Boolean getPaymentDelay();

    public ResetDates getResetDates();

    public DiscountingMethod getDiscountingMethod();

    public CompoundingMethodEnum getCompoundingMethod();

    public CashflowRepresentation getCashflowRepresentation();

    public StubPeriod getStubPeriod();

    public BondReference getBondReference();

    public String getFixedAmount();

    public String getFloatingAmount();

    public SpreadCalculationMethodEnum getSpreadCalculationMethod();

    public MetaFields getMeta();

    @Override
    public InterestRatePayout build();

    @Override
    public InterestRatePayoutBuilder toBuilder();

    public static InterestRatePayoutBuilder builder() {
        return new InterestRatePayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends InterestRatePayout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InterestRatePayout> getType() {
        return InterestRatePayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.class, this.getPrincipalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateSpecification"), processor, RateSpecification.class, this.getRateSpecification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, FieldWithMetaDayCountFractionEnum.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationPeriodDates"), processor, CalculationPeriodDates.class, this.getCalculationPeriodDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.class, this.getPaymentDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("paymentDelay"), Boolean.class, (Object)this.getPaymentDelay(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("resetDates"), processor, ResetDates.class, this.getResetDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("discountingMethod"), processor, DiscountingMethod.class, this.getDiscountingMethod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("compoundingMethod"), CompoundingMethodEnum.class, (Object)this.getCompoundingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashflowRepresentation"), processor, CashflowRepresentation.class, this.getCashflowRepresentation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("stubPeriod"), processor, StubPeriod.class, this.getStubPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("bondReference"), processor, BondReference.class, this.getBondReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedAmount"), String.class, (Object)this.getFixedAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingAmount"), String.class, (Object)this.getFloatingAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadCalculationMethod"), SpreadCalculationMethodEnum.class, (Object)this.getSpreadCalculationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class InterestRatePayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements InterestRatePayoutBuilder {
        protected RateSpecification.RateSpecificationBuilder rateSpecification;
        protected FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder dayCountFraction;
        protected CalculationPeriodDates.CalculationPeriodDatesBuilder calculationPeriodDates;
        protected PaymentDates.PaymentDatesBuilder paymentDates;
        protected AdjustableDate.AdjustableDateBuilder paymentDate;
        protected Boolean paymentDelay;
        protected ResetDates.ResetDatesBuilder resetDates;
        protected DiscountingMethod.DiscountingMethodBuilder discountingMethod;
        protected CompoundingMethodEnum compoundingMethod;
        protected CashflowRepresentation.CashflowRepresentationBuilder cashflowRepresentation;
        protected StubPeriod.StubPeriodBuilder stubPeriod;
        protected BondReference.BondReferenceBuilder bondReference;
        protected String fixedAmount;
        protected String floatingAmount;
        protected SpreadCalculationMethodEnum spreadCalculationMethod;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="rateSpecification")
        @RuneAttribute(value="rateSpecification")
        public RateSpecification.RateSpecificationBuilder getRateSpecification() {
            return this.rateSpecification;
        }

        @Override
        public RateSpecification.RateSpecificationBuilder getOrCreateRateSpecification() {
            RateSpecification.RateSpecificationBuilder result = this.rateSpecification != null ? this.rateSpecification : (this.rateSpecification = RateSpecification.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder getOrCreateDayCountFraction() {
            FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = FieldWithMetaDayCountFractionEnum.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodDates")
        @RuneAttribute(value="calculationPeriodDates")
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getCalculationPeriodDates() {
            return this.calculationPeriodDates;
        }

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getOrCreateCalculationPeriodDates() {
            CalculationPeriodDates.CalculationPeriodDatesBuilder result = this.calculationPeriodDates != null ? this.calculationPeriodDates : (this.calculationPeriodDates = CalculationPeriodDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDates")
        @RuneAttribute(value="paymentDates")
        public PaymentDates.PaymentDatesBuilder getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates() {
            PaymentDates.PaymentDatesBuilder result = this.paymentDates != null ? this.paymentDates : (this.paymentDates = PaymentDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public AdjustableDate.AdjustableDateBuilder getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getOrCreatePaymentDate() {
            AdjustableDate.AdjustableDateBuilder result = this.paymentDate != null ? this.paymentDate : (this.paymentDate = AdjustableDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDelay")
        @RuneAttribute(value="paymentDelay")
        public Boolean getPaymentDelay() {
            return this.paymentDelay;
        }

        @Override
        @RosettaAttribute(value="resetDates")
        @RuneAttribute(value="resetDates")
        public ResetDates.ResetDatesBuilder getResetDates() {
            return this.resetDates;
        }

        @Override
        public ResetDates.ResetDatesBuilder getOrCreateResetDates() {
            ResetDates.ResetDatesBuilder result = this.resetDates != null ? this.resetDates : (this.resetDates = ResetDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="discountingMethod")
        @RuneAttribute(value="discountingMethod")
        public DiscountingMethod.DiscountingMethodBuilder getDiscountingMethod() {
            return this.discountingMethod;
        }

        @Override
        public DiscountingMethod.DiscountingMethodBuilder getOrCreateDiscountingMethod() {
            DiscountingMethod.DiscountingMethodBuilder result = this.discountingMethod != null ? this.discountingMethod : (this.discountingMethod = DiscountingMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="compoundingMethod")
        @RuneAttribute(value="compoundingMethod")
        public CompoundingMethodEnum getCompoundingMethod() {
            return this.compoundingMethod;
        }

        @Override
        @RosettaAttribute(value="cashflowRepresentation")
        @RuneAttribute(value="cashflowRepresentation")
        public CashflowRepresentation.CashflowRepresentationBuilder getCashflowRepresentation() {
            return this.cashflowRepresentation;
        }

        @Override
        public CashflowRepresentation.CashflowRepresentationBuilder getOrCreateCashflowRepresentation() {
            CashflowRepresentation.CashflowRepresentationBuilder result = this.cashflowRepresentation != null ? this.cashflowRepresentation : (this.cashflowRepresentation = CashflowRepresentation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="stubPeriod")
        @RuneAttribute(value="stubPeriod")
        public StubPeriod.StubPeriodBuilder getStubPeriod() {
            return this.stubPeriod;
        }

        @Override
        public StubPeriod.StubPeriodBuilder getOrCreateStubPeriod() {
            StubPeriod.StubPeriodBuilder result = this.stubPeriod != null ? this.stubPeriod : (this.stubPeriod = StubPeriod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="bondReference")
        @RuneAttribute(value="bondReference")
        public BondReference.BondReferenceBuilder getBondReference() {
            return this.bondReference;
        }

        @Override
        public BondReference.BondReferenceBuilder getOrCreateBondReference() {
            BondReference.BondReferenceBuilder result = this.bondReference != null ? this.bondReference : (this.bondReference = BondReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedAmount")
        @RuneAttribute(value="fixedAmount")
        public String getFixedAmount() {
            return this.fixedAmount;
        }

        @Override
        @RosettaAttribute(value="floatingAmount")
        @RuneAttribute(value="floatingAmount")
        public String getFloatingAmount() {
            return this.floatingAmount;
        }

        @Override
        @RosettaAttribute(value="spreadCalculationMethod")
        @RuneAttribute(value="spreadCalculationMethod")
        public SpreadCalculationMethodEnum getSpreadCalculationMethod() {
            return this.spreadCalculationMethod;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public InterestRatePayoutBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public InterestRatePayoutBuilder setPriceQuantity(ResolvablePriceQuantity _priceQuantity) {
            this.priceQuantity = _priceQuantity == null ? null : _priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public InterestRatePayoutBuilder setPrincipalPayment(PrincipalPayments _principalPayment) {
            this.principalPayment = _principalPayment == null ? null : _principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public InterestRatePayoutBuilder setSettlementTerms(SettlementTerms _settlementTerms) {
            this.settlementTerms = _settlementTerms == null ? null : _settlementTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rateSpecification")
        @RuneAttribute(value="rateSpecification")
        public InterestRatePayoutBuilder setRateSpecification(RateSpecification _rateSpecification) {
            this.rateSpecification = _rateSpecification == null ? null : _rateSpecification.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public InterestRatePayoutBuilder setDayCountFraction(FieldWithMetaDayCountFractionEnum _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setDayCountFractionValue(DayCountFractionEnum _dayCountFraction) {
            this.getOrCreateDayCountFraction().setValue(_dayCountFraction);
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodDates")
        @RuneAttribute(value="calculationPeriodDates")
        public InterestRatePayoutBuilder setCalculationPeriodDates(CalculationPeriodDates _calculationPeriodDates) {
            this.calculationPeriodDates = _calculationPeriodDates == null ? null : _calculationPeriodDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDates")
        @RuneAttribute(value="paymentDates")
        public InterestRatePayoutBuilder setPaymentDates(PaymentDates _paymentDates) {
            this.paymentDates = _paymentDates == null ? null : _paymentDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public InterestRatePayoutBuilder setPaymentDate(AdjustableDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDelay")
        @RuneAttribute(value="paymentDelay")
        public InterestRatePayoutBuilder setPaymentDelay(Boolean _paymentDelay) {
            this.paymentDelay = _paymentDelay == null ? null : _paymentDelay;
            return this;
        }

        @Override
        @RosettaAttribute(value="resetDates")
        @RuneAttribute(value="resetDates")
        public InterestRatePayoutBuilder setResetDates(ResetDates _resetDates) {
            this.resetDates = _resetDates == null ? null : _resetDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="discountingMethod")
        @RuneAttribute(value="discountingMethod")
        public InterestRatePayoutBuilder setDiscountingMethod(DiscountingMethod _discountingMethod) {
            this.discountingMethod = _discountingMethod == null ? null : _discountingMethod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="compoundingMethod")
        @RuneAttribute(value="compoundingMethod")
        public InterestRatePayoutBuilder setCompoundingMethod(CompoundingMethodEnum _compoundingMethod) {
            this.compoundingMethod = _compoundingMethod == null ? null : _compoundingMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="cashflowRepresentation")
        @RuneAttribute(value="cashflowRepresentation")
        public InterestRatePayoutBuilder setCashflowRepresentation(CashflowRepresentation _cashflowRepresentation) {
            this.cashflowRepresentation = _cashflowRepresentation == null ? null : _cashflowRepresentation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="stubPeriod")
        @RuneAttribute(value="stubPeriod")
        public InterestRatePayoutBuilder setStubPeriod(StubPeriod _stubPeriod) {
            this.stubPeriod = _stubPeriod == null ? null : _stubPeriod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="bondReference")
        @RuneAttribute(value="bondReference")
        public InterestRatePayoutBuilder setBondReference(BondReference _bondReference) {
            this.bondReference = _bondReference == null ? null : _bondReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedAmount")
        @RuneAttribute(value="fixedAmount")
        public InterestRatePayoutBuilder setFixedAmount(String _fixedAmount) {
            this.fixedAmount = _fixedAmount == null ? null : _fixedAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingAmount")
        @RuneAttribute(value="floatingAmount")
        public InterestRatePayoutBuilder setFloatingAmount(String _floatingAmount) {
            this.floatingAmount = _floatingAmount == null ? null : _floatingAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadCalculationMethod")
        @RuneAttribute(value="spreadCalculationMethod")
        public InterestRatePayoutBuilder setSpreadCalculationMethod(SpreadCalculationMethodEnum _spreadCalculationMethod) {
            this.spreadCalculationMethod = _spreadCalculationMethod == null ? null : _spreadCalculationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public InterestRatePayoutBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayout build() {
            return new InterestRatePayoutImpl(this);
        }

        @Override
        public InterestRatePayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public InterestRatePayoutBuilder prune() {
            super.prune();
            if (this.rateSpecification != null && !this.rateSpecification.prune().hasData()) {
                this.rateSpecification = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            if (this.calculationPeriodDates != null && !this.calculationPeriodDates.prune().hasData()) {
                this.calculationPeriodDates = null;
            }
            if (this.paymentDates != null && !this.paymentDates.prune().hasData()) {
                this.paymentDates = null;
            }
            if (this.paymentDate != null && !this.paymentDate.prune().hasData()) {
                this.paymentDate = null;
            }
            if (this.resetDates != null && !this.resetDates.prune().hasData()) {
                this.resetDates = null;
            }
            if (this.discountingMethod != null && !this.discountingMethod.prune().hasData()) {
                this.discountingMethod = null;
            }
            if (this.cashflowRepresentation != null && !this.cashflowRepresentation.prune().hasData()) {
                this.cashflowRepresentation = null;
            }
            if (this.stubPeriod != null && !this.stubPeriod.prune().hasData()) {
                this.stubPeriod = null;
            }
            if (this.bondReference != null && !this.bondReference.prune().hasData()) {
                this.bondReference = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getRateSpecification() != null && this.getRateSpecification().hasData()) {
                return true;
            }
            if (this.getDayCountFraction() != null) {
                return true;
            }
            if (this.getCalculationPeriodDates() != null && this.getCalculationPeriodDates().hasData()) {
                return true;
            }
            if (this.getPaymentDates() != null && this.getPaymentDates().hasData()) {
                return true;
            }
            if (this.getPaymentDate() != null && this.getPaymentDate().hasData()) {
                return true;
            }
            if (this.getPaymentDelay() != null) {
                return true;
            }
            if (this.getResetDates() != null && this.getResetDates().hasData()) {
                return true;
            }
            if (this.getDiscountingMethod() != null && this.getDiscountingMethod().hasData()) {
                return true;
            }
            if (this.getCompoundingMethod() != null) {
                return true;
            }
            if (this.getCashflowRepresentation() != null && this.getCashflowRepresentation().hasData()) {
                return true;
            }
            if (this.getStubPeriod() != null && this.getStubPeriod().hasData()) {
                return true;
            }
            if (this.getBondReference() != null && this.getBondReference().hasData()) {
                return true;
            }
            if (this.getFixedAmount() != null) {
                return true;
            }
            if (this.getFloatingAmount() != null) {
                return true;
            }
            return this.getSpreadCalculationMethod() != null;
        }

        @Override
        public InterestRatePayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            InterestRatePayoutBuilder o = (InterestRatePayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRateSpecification(), (RosettaModelObjectBuilder)o.getRateSpecification(), this::setRateSpecification);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationPeriodDates(), (RosettaModelObjectBuilder)o.getCalculationPeriodDates(), this::setCalculationPeriodDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDates(), (RosettaModelObjectBuilder)o.getPaymentDates(), this::setPaymentDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDate(), (RosettaModelObjectBuilder)o.getPaymentDate(), this::setPaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getResetDates(), (RosettaModelObjectBuilder)o.getResetDates(), this::setResetDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDiscountingMethod(), (RosettaModelObjectBuilder)o.getDiscountingMethod(), this::setDiscountingMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashflowRepresentation(), (RosettaModelObjectBuilder)o.getCashflowRepresentation(), this::setCashflowRepresentation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStubPeriod(), (RosettaModelObjectBuilder)o.getStubPeriod(), this::setStubPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBondReference(), (RosettaModelObjectBuilder)o.getBondReference(), this::setBondReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getPaymentDelay(), (Object)o.getPaymentDelay(), this::setPaymentDelay, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCompoundingMethod(), (Object)o.getCompoundingMethod(), this::setCompoundingMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedAmount(), (Object)o.getFixedAmount(), this::setFixedAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingAmount(), (Object)o.getFloatingAmount(), this::setFloatingAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadCalculationMethod(), (Object)o.getSpreadCalculationMethod(), this::setSpreadCalculationMethod, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InterestRatePayout _that = (InterestRatePayout)this.getType().cast(o);
            if (!Objects.equals(this.rateSpecification, _that.getRateSpecification())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodDates, _that.getCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentDelay, _that.getPaymentDelay())) {
                return false;
            }
            if (!Objects.equals(this.resetDates, _that.getResetDates())) {
                return false;
            }
            if (!Objects.equals(this.discountingMethod, _that.getDiscountingMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.compoundingMethod, (Object)_that.getCompoundingMethod())) {
                return false;
            }
            if (!Objects.equals(this.cashflowRepresentation, _that.getCashflowRepresentation())) {
                return false;
            }
            if (!Objects.equals(this.stubPeriod, _that.getStubPeriod())) {
                return false;
            }
            if (!Objects.equals(this.bondReference, _that.getBondReference())) {
                return false;
            }
            if (!Objects.equals(this.fixedAmount, _that.getFixedAmount())) {
                return false;
            }
            if (!Objects.equals(this.floatingAmount, _that.getFloatingAmount())) {
                return false;
            }
            if (!Objects.equals((Object)this.spreadCalculationMethod, (Object)_that.getSpreadCalculationMethod())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rateSpecification != null ? this.rateSpecification.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodDates != null ? this.calculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentDelay != null ? this.paymentDelay.hashCode() : 0);
            _result = 31 * _result + (this.resetDates != null ? this.resetDates.hashCode() : 0);
            _result = 31 * _result + (this.discountingMethod != null ? this.discountingMethod.hashCode() : 0);
            _result = 31 * _result + (this.compoundingMethod != null ? ((Object)((Object)this.compoundingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashflowRepresentation != null ? this.cashflowRepresentation.hashCode() : 0);
            _result = 31 * _result + (this.stubPeriod != null ? this.stubPeriod.hashCode() : 0);
            _result = 31 * _result + (this.bondReference != null ? this.bondReference.hashCode() : 0);
            _result = 31 * _result + (this.fixedAmount != null ? this.fixedAmount.hashCode() : 0);
            _result = 31 * _result + (this.floatingAmount != null ? this.floatingAmount.hashCode() : 0);
            _result = 31 * _result + (this.spreadCalculationMethod != null ? ((Object)((Object)this.spreadCalculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InterestRatePayoutBuilder {rateSpecification=" + this.rateSpecification + ", dayCountFraction=" + this.dayCountFraction + ", calculationPeriodDates=" + this.calculationPeriodDates + ", paymentDates=" + this.paymentDates + ", paymentDate=" + this.paymentDate + ", paymentDelay=" + this.paymentDelay + ", resetDates=" + this.resetDates + ", discountingMethod=" + this.discountingMethod + ", compoundingMethod=" + (Object)((Object)this.compoundingMethod) + ", cashflowRepresentation=" + this.cashflowRepresentation + ", stubPeriod=" + this.stubPeriod + ", bondReference=" + this.bondReference + ", fixedAmount=" + this.fixedAmount + ", floatingAmount=" + this.floatingAmount + ", spreadCalculationMethod=" + (Object)((Object)this.spreadCalculationMethod) + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static interface InterestRatePayoutBuilder
    extends InterestRatePayout,
    PayoutBase.PayoutBaseBuilder,
    GlobalKey.GlobalKeyBuilder {
        public RateSpecification.RateSpecificationBuilder getOrCreateRateSpecification();

        @Override
        public RateSpecification.RateSpecificationBuilder getRateSpecification();

        public FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder getOrCreateDayCountFraction();

        @Override
        public FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder getDayCountFraction();

        public CalculationPeriodDates.CalculationPeriodDatesBuilder getOrCreateCalculationPeriodDates();

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getCalculationPeriodDates();

        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates();

        @Override
        public PaymentDates.PaymentDatesBuilder getPaymentDates();

        public AdjustableDate.AdjustableDateBuilder getOrCreatePaymentDate();

        @Override
        public AdjustableDate.AdjustableDateBuilder getPaymentDate();

        public ResetDates.ResetDatesBuilder getOrCreateResetDates();

        @Override
        public ResetDates.ResetDatesBuilder getResetDates();

        public DiscountingMethod.DiscountingMethodBuilder getOrCreateDiscountingMethod();

        @Override
        public DiscountingMethod.DiscountingMethodBuilder getDiscountingMethod();

        public CashflowRepresentation.CashflowRepresentationBuilder getOrCreateCashflowRepresentation();

        @Override
        public CashflowRepresentation.CashflowRepresentationBuilder getCashflowRepresentation();

        public StubPeriod.StubPeriodBuilder getOrCreateStubPeriod();

        @Override
        public StubPeriod.StubPeriodBuilder getStubPeriod();

        public BondReference.BondReferenceBuilder getOrCreateBondReference();

        @Override
        public BondReference.BondReferenceBuilder getBondReference();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        @Override
        public InterestRatePayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public InterestRatePayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public InterestRatePayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public InterestRatePayoutBuilder setSettlementTerms(SettlementTerms var1);

        public InterestRatePayoutBuilder setRateSpecification(RateSpecification var1);

        public InterestRatePayoutBuilder setDayCountFraction(FieldWithMetaDayCountFractionEnum var1);

        public InterestRatePayoutBuilder setDayCountFractionValue(DayCountFractionEnum var1);

        public InterestRatePayoutBuilder setCalculationPeriodDates(CalculationPeriodDates var1);

        public InterestRatePayoutBuilder setPaymentDates(PaymentDates var1);

        public InterestRatePayoutBuilder setPaymentDate(AdjustableDate var1);

        public InterestRatePayoutBuilder setPaymentDelay(Boolean var1);

        public InterestRatePayoutBuilder setResetDates(ResetDates var1);

        public InterestRatePayoutBuilder setDiscountingMethod(DiscountingMethod var1);

        public InterestRatePayoutBuilder setCompoundingMethod(CompoundingMethodEnum var1);

        public InterestRatePayoutBuilder setCashflowRepresentation(CashflowRepresentation var1);

        public InterestRatePayoutBuilder setStubPeriod(StubPeriod var1);

        public InterestRatePayoutBuilder setBondReference(BondReference var1);

        public InterestRatePayoutBuilder setFixedAmount(String var1);

        public InterestRatePayoutBuilder setFloatingAmount(String var1);

        public InterestRatePayoutBuilder setSpreadCalculationMethod(SpreadCalculationMethodEnum var1);

        public InterestRatePayoutBuilder setMeta(MetaFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.ResolvablePriceQuantityBuilder.class, (RosettaModelObjectBuilder)this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.PrincipalPaymentsBuilder.class, (RosettaModelObjectBuilder)this.getPrincipalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, (RosettaModelObjectBuilder)this.getSettlementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateSpecification"), processor, RateSpecification.RateSpecificationBuilder.class, this.getRateSpecification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationPeriodDates"), processor, CalculationPeriodDates.CalculationPeriodDatesBuilder.class, this.getCalculationPeriodDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.PaymentDatesBuilder.class, this.getPaymentDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.AdjustableDateBuilder.class, this.getPaymentDate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("paymentDelay"), Boolean.class, (Object)this.getPaymentDelay(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("resetDates"), processor, ResetDates.ResetDatesBuilder.class, this.getResetDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("discountingMethod"), processor, DiscountingMethod.DiscountingMethodBuilder.class, this.getDiscountingMethod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("compoundingMethod"), CompoundingMethodEnum.class, (Object)this.getCompoundingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashflowRepresentation"), processor, CashflowRepresentation.CashflowRepresentationBuilder.class, this.getCashflowRepresentation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("stubPeriod"), processor, StubPeriod.StubPeriodBuilder.class, this.getStubPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("bondReference"), processor, BondReference.BondReferenceBuilder.class, this.getBondReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedAmount"), String.class, (Object)this.getFixedAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingAmount"), String.class, (Object)this.getFloatingAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadCalculationMethod"), SpreadCalculationMethodEnum.class, (Object)this.getSpreadCalculationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        @Override
        public InterestRatePayoutBuilder prune();
    }

    public static class InterestRatePayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements InterestRatePayout {
        private final RateSpecification rateSpecification;
        private final FieldWithMetaDayCountFractionEnum dayCountFraction;
        private final CalculationPeriodDates calculationPeriodDates;
        private final PaymentDates paymentDates;
        private final AdjustableDate paymentDate;
        private final Boolean paymentDelay;
        private final ResetDates resetDates;
        private final DiscountingMethod discountingMethod;
        private final CompoundingMethodEnum compoundingMethod;
        private final CashflowRepresentation cashflowRepresentation;
        private final StubPeriod stubPeriod;
        private final BondReference bondReference;
        private final String fixedAmount;
        private final String floatingAmount;
        private final SpreadCalculationMethodEnum spreadCalculationMethod;
        private final MetaFields meta;

        protected InterestRatePayoutImpl(InterestRatePayoutBuilder builder) {
            super(builder);
            this.rateSpecification = Optional.ofNullable(builder.getRateSpecification()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
            this.calculationPeriodDates = Optional.ofNullable(builder.getCalculationPeriodDates()).map(f -> f.build()).orElse(null);
            this.paymentDates = Optional.ofNullable(builder.getPaymentDates()).map(f -> f.build()).orElse(null);
            this.paymentDate = Optional.ofNullable(builder.getPaymentDate()).map(f -> f.build()).orElse(null);
            this.paymentDelay = builder.getPaymentDelay();
            this.resetDates = Optional.ofNullable(builder.getResetDates()).map(f -> f.build()).orElse(null);
            this.discountingMethod = Optional.ofNullable(builder.getDiscountingMethod()).map(f -> f.build()).orElse(null);
            this.compoundingMethod = builder.getCompoundingMethod();
            this.cashflowRepresentation = Optional.ofNullable(builder.getCashflowRepresentation()).map(f -> f.build()).orElse(null);
            this.stubPeriod = Optional.ofNullable(builder.getStubPeriod()).map(f -> f.build()).orElse(null);
            this.bondReference = Optional.ofNullable(builder.getBondReference()).map(f -> f.build()).orElse(null);
            this.fixedAmount = builder.getFixedAmount();
            this.floatingAmount = builder.getFloatingAmount();
            this.spreadCalculationMethod = builder.getSpreadCalculationMethod();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="rateSpecification")
        @RuneAttribute(value="rateSpecification")
        public RateSpecification getRateSpecification() {
            return this.rateSpecification;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public FieldWithMetaDayCountFractionEnum getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodDates")
        @RuneAttribute(value="calculationPeriodDates")
        public CalculationPeriodDates getCalculationPeriodDates() {
            return this.calculationPeriodDates;
        }

        @Override
        @RosettaAttribute(value="paymentDates")
        @RuneAttribute(value="paymentDates")
        public PaymentDates getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public AdjustableDate getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        @RosettaAttribute(value="paymentDelay")
        @RuneAttribute(value="paymentDelay")
        public Boolean getPaymentDelay() {
            return this.paymentDelay;
        }

        @Override
        @RosettaAttribute(value="resetDates")
        @RuneAttribute(value="resetDates")
        public ResetDates getResetDates() {
            return this.resetDates;
        }

        @Override
        @RosettaAttribute(value="discountingMethod")
        @RuneAttribute(value="discountingMethod")
        public DiscountingMethod getDiscountingMethod() {
            return this.discountingMethod;
        }

        @Override
        @RosettaAttribute(value="compoundingMethod")
        @RuneAttribute(value="compoundingMethod")
        public CompoundingMethodEnum getCompoundingMethod() {
            return this.compoundingMethod;
        }

        @Override
        @RosettaAttribute(value="cashflowRepresentation")
        @RuneAttribute(value="cashflowRepresentation")
        public CashflowRepresentation getCashflowRepresentation() {
            return this.cashflowRepresentation;
        }

        @Override
        @RosettaAttribute(value="stubPeriod")
        @RuneAttribute(value="stubPeriod")
        public StubPeriod getStubPeriod() {
            return this.stubPeriod;
        }

        @Override
        @RosettaAttribute(value="bondReference")
        @RuneAttribute(value="bondReference")
        public BondReference getBondReference() {
            return this.bondReference;
        }

        @Override
        @RosettaAttribute(value="fixedAmount")
        @RuneAttribute(value="fixedAmount")
        public String getFixedAmount() {
            return this.fixedAmount;
        }

        @Override
        @RosettaAttribute(value="floatingAmount")
        @RuneAttribute(value="floatingAmount")
        public String getFloatingAmount() {
            return this.floatingAmount;
        }

        @Override
        @RosettaAttribute(value="spreadCalculationMethod")
        @RuneAttribute(value="spreadCalculationMethod")
        public SpreadCalculationMethodEnum getSpreadCalculationMethod() {
            return this.spreadCalculationMethod;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public InterestRatePayout build() {
            return this;
        }

        @Override
        public InterestRatePayoutBuilder toBuilder() {
            InterestRatePayoutBuilder builder = InterestRatePayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InterestRatePayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRateSpecification()).ifPresent(builder::setRateSpecification);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getCalculationPeriodDates()).ifPresent(builder::setCalculationPeriodDates);
            Optional.ofNullable(this.getPaymentDates()).ifPresent(builder::setPaymentDates);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
            Optional.ofNullable(this.getPaymentDelay()).ifPresent(builder::setPaymentDelay);
            Optional.ofNullable(this.getResetDates()).ifPresent(builder::setResetDates);
            Optional.ofNullable(this.getDiscountingMethod()).ifPresent(builder::setDiscountingMethod);
            Optional.ofNullable(this.getCompoundingMethod()).ifPresent(builder::setCompoundingMethod);
            Optional.ofNullable(this.getCashflowRepresentation()).ifPresent(builder::setCashflowRepresentation);
            Optional.ofNullable(this.getStubPeriod()).ifPresent(builder::setStubPeriod);
            Optional.ofNullable(this.getBondReference()).ifPresent(builder::setBondReference);
            Optional.ofNullable(this.getFixedAmount()).ifPresent(builder::setFixedAmount);
            Optional.ofNullable(this.getFloatingAmount()).ifPresent(builder::setFloatingAmount);
            Optional.ofNullable(this.getSpreadCalculationMethod()).ifPresent(builder::setSpreadCalculationMethod);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InterestRatePayout _that = (InterestRatePayout)this.getType().cast(o);
            if (!Objects.equals(this.rateSpecification, _that.getRateSpecification())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodDates, _that.getCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentDelay, _that.getPaymentDelay())) {
                return false;
            }
            if (!Objects.equals(this.resetDates, _that.getResetDates())) {
                return false;
            }
            if (!Objects.equals(this.discountingMethod, _that.getDiscountingMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.compoundingMethod, (Object)_that.getCompoundingMethod())) {
                return false;
            }
            if (!Objects.equals(this.cashflowRepresentation, _that.getCashflowRepresentation())) {
                return false;
            }
            if (!Objects.equals(this.stubPeriod, _that.getStubPeriod())) {
                return false;
            }
            if (!Objects.equals(this.bondReference, _that.getBondReference())) {
                return false;
            }
            if (!Objects.equals(this.fixedAmount, _that.getFixedAmount())) {
                return false;
            }
            if (!Objects.equals(this.floatingAmount, _that.getFloatingAmount())) {
                return false;
            }
            if (!Objects.equals((Object)this.spreadCalculationMethod, (Object)_that.getSpreadCalculationMethod())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rateSpecification != null ? this.rateSpecification.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodDates != null ? this.calculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentDelay != null ? this.paymentDelay.hashCode() : 0);
            _result = 31 * _result + (this.resetDates != null ? this.resetDates.hashCode() : 0);
            _result = 31 * _result + (this.discountingMethod != null ? this.discountingMethod.hashCode() : 0);
            _result = 31 * _result + (this.compoundingMethod != null ? ((Object)((Object)this.compoundingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashflowRepresentation != null ? this.cashflowRepresentation.hashCode() : 0);
            _result = 31 * _result + (this.stubPeriod != null ? this.stubPeriod.hashCode() : 0);
            _result = 31 * _result + (this.bondReference != null ? this.bondReference.hashCode() : 0);
            _result = 31 * _result + (this.fixedAmount != null ? this.fixedAmount.hashCode() : 0);
            _result = 31 * _result + (this.floatingAmount != null ? this.floatingAmount.hashCode() : 0);
            _result = 31 * _result + (this.spreadCalculationMethod != null ? ((Object)((Object)this.spreadCalculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InterestRatePayout {rateSpecification=" + this.rateSpecification + ", dayCountFraction=" + this.dayCountFraction + ", calculationPeriodDates=" + this.calculationPeriodDates + ", paymentDates=" + this.paymentDates + ", paymentDate=" + this.paymentDate + ", paymentDelay=" + this.paymentDelay + ", resetDates=" + this.resetDates + ", discountingMethod=" + this.discountingMethod + ", compoundingMethod=" + (Object)((Object)this.compoundingMethod) + ", cashflowRepresentation=" + this.cashflowRepresentation + ", stubPeriod=" + this.stubPeriod + ", bondReference=" + this.bondReference + ", fixedAmount=" + this.fixedAmount + ", floatingAmount=" + this.floatingAmount + ", spreadCalculationMethod=" + (Object)((Object)this.spreadCalculationMethod) + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }
}

