/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.ObservationSource;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ObservationSourceCurveInformationSource")
@ImplementedBy(value=Default.class)
public interface ObservationSourceCurveInformationSource
extends Validator<ObservationSource> {
    public static final String NAME = "ObservationSourceCurveInformationSource";
    public static final String DEFINITION = "(curve exists and informationSource exists) or curve exists or informationSource exists";

    public static class NoOp
    implements ObservationSourceCurveInformationSource {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ObservationSource observationSource) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ObservationSourceCurveInformationSource {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ObservationSource observationSource) {
            ComparisonResult result = this.executeDataRule(observationSource);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ObservationSourceCurveInformationSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ObservationSource", (RosettaPath)path, (String)ObservationSourceCurveInformationSource.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ObservationSourceCurveInformationSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ObservationSource", (RosettaPath)path, (String)ObservationSourceCurveInformationSource.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ObservationSource observationSource) {
            try {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)observationSource).map("getCurve", _observationSource -> _observationSource.getCurve())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)observationSource).map("getInformationSource", _observationSource -> _observationSource.getInformationSource()))).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)observationSource).map("getCurve", _observationSource -> _observationSource.getCurve()))).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)observationSource).map("getInformationSource", _observationSource -> _observationSource.getInformationSource())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

