/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradeExtraordinaryEvents")
@ImplementedBy(value=Default.class)
public interface TradeExtraordinaryEvents
extends Validator<Trade> {
    public static final String NAME = "TradeExtraordinaryEvents";
    public static final String DEFINITION = "if contractDetails -> documentation -> agreementTerms -> agreement -> transactionAdditionalTerms -> equityAdditionalTerms -> extraordinaryEvents exists then tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> performancePayout -> returnTerms -> priceReturnTerms exists or tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> optionPayout -> underlier -> security exists";

    public static class NoOp
    implements TradeExtraordinaryEvents {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradeExtraordinaryEvents {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradeExtraordinaryEvents.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeExtraordinaryEvents.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradeExtraordinaryEvents.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeExtraordinaryEvents.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getContractDetails", _trade -> _trade.getContractDetails()).mapC("getDocumentation", contractDetails -> contractDetails.getDocumentation()).map("getAgreementTerms", legalAgreement -> legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getTransactionAdditionalTerms", agreement -> agreement.getTransactionAdditionalTerms()).map("getEquityAdditionalTerms", transactionAdditionalTerms -> transactionAdditionalTerms.getEquityAdditionalTerms()).map("getExtraordinaryEvents", equityAdditionalTerms -> equityAdditionalTerms.getExtraordinaryEvents())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getSecurity", product -> product.getSecurity())));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

