/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_OnDemandRateChangePriceChangeInstruction;
import cdm.event.common.functions.Create_OnDemandRateChangeTermsChangeInstruction;
import cdm.event.common.functions.Create_TerminationInstruction;
import cdm.product.template.ContractualProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_OnDemandRateChangePrimitiveInstructionDefault.class)
public abstract class Create_OnDemandRateChangePrimitiveInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_OnDemandRateChangePriceChangeInstruction create_OnDemandRateChangePriceChangeInstruction;
    @Inject
    protected Create_OnDemandRateChangeTermsChangeInstruction create_OnDemandRateChangeTermsChangeInstruction;
    @Inject
    protected Create_TerminationInstruction create_TerminationInstruction;

    public PrimitiveInstruction evaluate(TradeState tradeState, AdjustableOrRelativeDate effectiveDate, BigDecimal agreedRate) {
        PrimitiveInstruction instruction;
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct())), "Only a contractual product can have a rate change.");
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All), "Rate change only works for a trade with a single trade lot.");
        PrimitiveInstruction.PrimitiveInstructionBuilder instructionBuilder = this.doEvaluate(tradeState, effectiveDate, agreedRate);
        if (instructionBuilder == null) {
            instruction = null;
        } else {
            instruction = instructionBuilder.build();
            this.objectValidator.validate(PrimitiveInstruction.class, (RosettaModelObject)instruction);
        }
        return instruction;
    }

    protected abstract PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState var1, AdjustableOrRelativeDate var2, BigDecimal var3);

    public static class Create_OnDemandRateChangePrimitiveInstructionDefault
    extends Create_OnDemandRateChangePrimitiveInstruction {
        @Override
        protected PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState tradeState, AdjustableOrRelativeDate effectiveDate, BigDecimal agreedRate) {
            PrimitiveInstruction.PrimitiveInstructionBuilder instruction = PrimitiveInstruction.builder();
            return this.assignOutput(instruction, tradeState, effectiveDate, agreedRate);
        }

        protected PrimitiveInstruction.PrimitiveInstructionBuilder assignOutput(PrimitiveInstruction.PrimitiveInstructionBuilder instruction, TradeState tradeState, AdjustableOrRelativeDate effectiveDate, BigDecimal agreedRate) {
            instruction.getOrCreateSplit().setBreakdown(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.create_TerminationInstruction.evaluate(tradeState))}).getMulti());
            instruction.getOrCreateSplit().addBreakdown(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)PrimitiveInstruction.builder().setQuantityChange(this.create_OnDemandRateChangePriceChangeInstruction.evaluate(MapperS.of((Object)((TradeLot)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).getMulti(), agreedRate)).setTermsChange(this.create_OnDemandRateChangeTermsChangeInstruction.evaluate((ContractualProduct)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).get(), effectiveDate)).build())}).getMulti());
            return Optional.ofNullable(instruction).map(o -> o.prune()).orElse(null);
        }
    }
}

