/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.party.Party;
import cdm.event.common.BillingRecordInstruction;
import cdm.event.common.BillingSummaryInstruction;
import cdm.event.common.meta.BillingInstructionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="BillingInstruction", builder=BillingInstructionBuilderImpl.class, version="5.28.0")
@RuneDataType(value="BillingInstruction", model="cdm", builder=BillingInstructionBuilderImpl.class, version="5.28.0")
public interface BillingInstruction
extends RosettaModelObject {
    public static final BillingInstructionMeta metaData = new BillingInstructionMeta();

    public Party getSendingParty();

    public Party getReceivingParty();

    public Date getBillingStartDate();

    public Date getBillingEndDate();

    public List<? extends BillingRecordInstruction> getBillingRecordInstruction();

    public List<? extends BillingSummaryInstruction> getBillingSummary();

    public BillingInstruction build();

    public BillingInstructionBuilder toBuilder();

    public static BillingInstructionBuilder builder() {
        return new BillingInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends BillingInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BillingInstruction> getType() {
        return BillingInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("sendingParty"), processor, Party.class, this.getSendingParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("receivingParty"), processor, Party.class, this.getReceivingParty(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("billingStartDate"), Date.class, (Object)this.getBillingStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("billingEndDate"), Date.class, (Object)this.getBillingEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("billingRecordInstruction"), processor, BillingRecordInstruction.class, this.getBillingRecordInstruction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("billingSummary"), processor, BillingSummaryInstruction.class, this.getBillingSummary(), new AttributeMeta[0]);
    }

    public static class BillingInstructionBuilderImpl
    implements BillingInstructionBuilder {
        protected Party.PartyBuilder sendingParty;
        protected Party.PartyBuilder receivingParty;
        protected Date billingStartDate;
        protected Date billingEndDate;
        protected List<BillingRecordInstruction.BillingRecordInstructionBuilder> billingRecordInstruction = new ArrayList<BillingRecordInstruction.BillingRecordInstructionBuilder>();
        protected List<BillingSummaryInstruction.BillingSummaryInstructionBuilder> billingSummary = new ArrayList<BillingSummaryInstruction.BillingSummaryInstructionBuilder>();

        @Override
        @RosettaAttribute(value="sendingParty", isRequired=true)
        @RuneAttribute(value="sendingParty", isRequired=true)
        public Party.PartyBuilder getSendingParty() {
            return this.sendingParty;
        }

        @Override
        public Party.PartyBuilder getOrCreateSendingParty() {
            Party.PartyBuilder result = this.sendingParty != null ? this.sendingParty : (this.sendingParty = Party.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="receivingParty", isRequired=true)
        @RuneAttribute(value="receivingParty", isRequired=true)
        public Party.PartyBuilder getReceivingParty() {
            return this.receivingParty;
        }

        @Override
        public Party.PartyBuilder getOrCreateReceivingParty() {
            Party.PartyBuilder result = this.receivingParty != null ? this.receivingParty : (this.receivingParty = Party.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="billingStartDate", isRequired=true)
        @RuneAttribute(value="billingStartDate", isRequired=true)
        public Date getBillingStartDate() {
            return this.billingStartDate;
        }

        @Override
        @RosettaAttribute(value="billingEndDate", isRequired=true)
        @RuneAttribute(value="billingEndDate", isRequired=true)
        public Date getBillingEndDate() {
            return this.billingEndDate;
        }

        @Override
        @RosettaAttribute(value="billingRecordInstruction", isRequired=true)
        @RuneAttribute(value="billingRecordInstruction", isRequired=true)
        public List<? extends BillingRecordInstruction.BillingRecordInstructionBuilder> getBillingRecordInstruction() {
            return this.billingRecordInstruction;
        }

        @Override
        public BillingRecordInstruction.BillingRecordInstructionBuilder getOrCreateBillingRecordInstruction(int index) {
            if (this.billingRecordInstruction == null) {
                this.billingRecordInstruction = new ArrayList<BillingRecordInstruction.BillingRecordInstructionBuilder>();
            }
            return (BillingRecordInstruction.BillingRecordInstructionBuilder)this.getIndex(this.billingRecordInstruction, index, () -> {
                BillingRecordInstruction.BillingRecordInstructionBuilder newBillingRecordInstruction = BillingRecordInstruction.builder();
                return newBillingRecordInstruction;
            });
        }

        @Override
        @RosettaAttribute(value="billingSummary")
        @RuneAttribute(value="billingSummary")
        public List<? extends BillingSummaryInstruction.BillingSummaryInstructionBuilder> getBillingSummary() {
            return this.billingSummary;
        }

        @Override
        public BillingSummaryInstruction.BillingSummaryInstructionBuilder getOrCreateBillingSummary(int index) {
            if (this.billingSummary == null) {
                this.billingSummary = new ArrayList<BillingSummaryInstruction.BillingSummaryInstructionBuilder>();
            }
            return (BillingSummaryInstruction.BillingSummaryInstructionBuilder)this.getIndex(this.billingSummary, index, () -> {
                BillingSummaryInstruction.BillingSummaryInstructionBuilder newBillingSummary = BillingSummaryInstruction.builder();
                return newBillingSummary;
            });
        }

        @Override
        @RosettaAttribute(value="sendingParty", isRequired=true)
        @RuneAttribute(value="sendingParty", isRequired=true)
        public BillingInstructionBuilder setSendingParty(Party _sendingParty) {
            this.sendingParty = _sendingParty == null ? null : _sendingParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="receivingParty", isRequired=true)
        @RuneAttribute(value="receivingParty", isRequired=true)
        public BillingInstructionBuilder setReceivingParty(Party _receivingParty) {
            this.receivingParty = _receivingParty == null ? null : _receivingParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="billingStartDate", isRequired=true)
        @RuneAttribute(value="billingStartDate", isRequired=true)
        public BillingInstructionBuilder setBillingStartDate(Date _billingStartDate) {
            this.billingStartDate = _billingStartDate == null ? null : _billingStartDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="billingEndDate", isRequired=true)
        @RuneAttribute(value="billingEndDate", isRequired=true)
        public BillingInstructionBuilder setBillingEndDate(Date _billingEndDate) {
            this.billingEndDate = _billingEndDate == null ? null : _billingEndDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="billingRecordInstruction", isRequired=true)
        @RuneAttribute(value="billingRecordInstruction", isRequired=true)
        public BillingInstructionBuilder addBillingRecordInstruction(BillingRecordInstruction _billingRecordInstruction) {
            if (_billingRecordInstruction != null) {
                this.billingRecordInstruction.add(_billingRecordInstruction.toBuilder());
            }
            return this;
        }

        @Override
        public BillingInstructionBuilder addBillingRecordInstruction(BillingRecordInstruction _billingRecordInstruction, int idx) {
            this.getIndex(this.billingRecordInstruction, idx, () -> _billingRecordInstruction.toBuilder());
            return this;
        }

        @Override
        public BillingInstructionBuilder addBillingRecordInstruction(List<? extends BillingRecordInstruction> billingRecordInstructions) {
            if (billingRecordInstructions != null) {
                for (BillingRecordInstruction billingRecordInstruction : billingRecordInstructions) {
                    this.billingRecordInstruction.add(billingRecordInstruction.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="billingRecordInstruction")
        public BillingInstructionBuilder setBillingRecordInstruction(List<? extends BillingRecordInstruction> billingRecordInstructions) {
            this.billingRecordInstruction = billingRecordInstructions == null ? new ArrayList<BillingRecordInstruction.BillingRecordInstructionBuilder>() : (List)billingRecordInstructions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="billingSummary")
        @RuneAttribute(value="billingSummary")
        public BillingInstructionBuilder addBillingSummary(BillingSummaryInstruction _billingSummary) {
            if (_billingSummary != null) {
                this.billingSummary.add(_billingSummary.toBuilder());
            }
            return this;
        }

        @Override
        public BillingInstructionBuilder addBillingSummary(BillingSummaryInstruction _billingSummary, int idx) {
            this.getIndex(this.billingSummary, idx, () -> _billingSummary.toBuilder());
            return this;
        }

        @Override
        public BillingInstructionBuilder addBillingSummary(List<? extends BillingSummaryInstruction> billingSummarys) {
            if (billingSummarys != null) {
                for (BillingSummaryInstruction billingSummaryInstruction : billingSummarys) {
                    this.billingSummary.add(billingSummaryInstruction.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="billingSummary")
        public BillingInstructionBuilder setBillingSummary(List<? extends BillingSummaryInstruction> billingSummarys) {
            this.billingSummary = billingSummarys == null ? new ArrayList<BillingSummaryInstruction.BillingSummaryInstructionBuilder>() : (List)billingSummarys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BillingInstruction build() {
            return new BillingInstructionImpl(this);
        }

        @Override
        public BillingInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public BillingInstructionBuilder prune() {
            if (this.sendingParty != null && !this.sendingParty.prune().hasData()) {
                this.sendingParty = null;
            }
            if (this.receivingParty != null && !this.receivingParty.prune().hasData()) {
                this.receivingParty = null;
            }
            this.billingRecordInstruction = this.billingRecordInstruction.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.billingSummary = this.billingSummary.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getSendingParty() != null && this.getSendingParty().hasData()) {
                return true;
            }
            if (this.getReceivingParty() != null && this.getReceivingParty().hasData()) {
                return true;
            }
            if (this.getBillingStartDate() != null) {
                return true;
            }
            if (this.getBillingEndDate() != null) {
                return true;
            }
            if (this.getBillingRecordInstruction() != null && this.getBillingRecordInstruction().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getBillingSummary() != null && this.getBillingSummary().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public BillingInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BillingInstructionBuilder o = (BillingInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSendingParty(), (RosettaModelObjectBuilder)o.getSendingParty(), this::setSendingParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReceivingParty(), (RosettaModelObjectBuilder)o.getReceivingParty(), this::setReceivingParty);
            merger.mergeRosetta(this.getBillingRecordInstruction(), o.getBillingRecordInstruction(), this::getOrCreateBillingRecordInstruction);
            merger.mergeRosetta(this.getBillingSummary(), o.getBillingSummary(), this::getOrCreateBillingSummary);
            merger.mergeBasic((Object)this.getBillingStartDate(), (Object)o.getBillingStartDate(), this::setBillingStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBillingEndDate(), (Object)o.getBillingEndDate(), this::setBillingEndDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BillingInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.sendingParty, _that.getSendingParty())) {
                return false;
            }
            if (!Objects.equals(this.receivingParty, _that.getReceivingParty())) {
                return false;
            }
            if (!Objects.equals(this.billingStartDate, _that.getBillingStartDate())) {
                return false;
            }
            if (!Objects.equals(this.billingEndDate, _that.getBillingEndDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.billingRecordInstruction, _that.getBillingRecordInstruction())) {
                return false;
            }
            return ListEquals.listEquals(this.billingSummary, _that.getBillingSummary());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.sendingParty != null ? this.sendingParty.hashCode() : 0);
            _result = 31 * _result + (this.receivingParty != null ? this.receivingParty.hashCode() : 0);
            _result = 31 * _result + (this.billingStartDate != null ? this.billingStartDate.hashCode() : 0);
            _result = 31 * _result + (this.billingEndDate != null ? this.billingEndDate.hashCode() : 0);
            _result = 31 * _result + (this.billingRecordInstruction != null ? this.billingRecordInstruction.hashCode() : 0);
            _result = 31 * _result + (this.billingSummary != null ? this.billingSummary.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BillingInstructionBuilder {sendingParty=" + this.sendingParty + ", receivingParty=" + this.receivingParty + ", billingStartDate=" + this.billingStartDate + ", billingEndDate=" + this.billingEndDate + ", billingRecordInstruction=" + this.billingRecordInstruction + ", billingSummary=" + this.billingSummary + '}';
        }
    }

    public static interface BillingInstructionBuilder
    extends BillingInstruction,
    RosettaModelObjectBuilder {
        public Party.PartyBuilder getOrCreateSendingParty();

        @Override
        public Party.PartyBuilder getSendingParty();

        public Party.PartyBuilder getOrCreateReceivingParty();

        @Override
        public Party.PartyBuilder getReceivingParty();

        public BillingRecordInstruction.BillingRecordInstructionBuilder getOrCreateBillingRecordInstruction(int var1);

        public List<? extends BillingRecordInstruction.BillingRecordInstructionBuilder> getBillingRecordInstruction();

        public BillingSummaryInstruction.BillingSummaryInstructionBuilder getOrCreateBillingSummary(int var1);

        public List<? extends BillingSummaryInstruction.BillingSummaryInstructionBuilder> getBillingSummary();

        public BillingInstructionBuilder setSendingParty(Party var1);

        public BillingInstructionBuilder setReceivingParty(Party var1);

        public BillingInstructionBuilder setBillingStartDate(Date var1);

        public BillingInstructionBuilder setBillingEndDate(Date var1);

        public BillingInstructionBuilder addBillingRecordInstruction(BillingRecordInstruction var1);

        public BillingInstructionBuilder addBillingRecordInstruction(BillingRecordInstruction var1, int var2);

        public BillingInstructionBuilder addBillingRecordInstruction(List<? extends BillingRecordInstruction> var1);

        public BillingInstructionBuilder setBillingRecordInstruction(List<? extends BillingRecordInstruction> var1);

        public BillingInstructionBuilder addBillingSummary(BillingSummaryInstruction var1);

        public BillingInstructionBuilder addBillingSummary(BillingSummaryInstruction var1, int var2);

        public BillingInstructionBuilder addBillingSummary(List<? extends BillingSummaryInstruction> var1);

        public BillingInstructionBuilder setBillingSummary(List<? extends BillingSummaryInstruction> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("sendingParty"), processor, Party.PartyBuilder.class, this.getSendingParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("receivingParty"), processor, Party.PartyBuilder.class, this.getReceivingParty(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("billingStartDate"), Date.class, (Object)this.getBillingStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("billingEndDate"), Date.class, (Object)this.getBillingEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("billingRecordInstruction"), processor, BillingRecordInstruction.BillingRecordInstructionBuilder.class, this.getBillingRecordInstruction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("billingSummary"), processor, BillingSummaryInstruction.BillingSummaryInstructionBuilder.class, this.getBillingSummary(), new AttributeMeta[0]);
        }

        public BillingInstructionBuilder prune();
    }

    public static class BillingInstructionImpl
    implements BillingInstruction {
        private final Party sendingParty;
        private final Party receivingParty;
        private final Date billingStartDate;
        private final Date billingEndDate;
        private final List<? extends BillingRecordInstruction> billingRecordInstruction;
        private final List<? extends BillingSummaryInstruction> billingSummary;

        protected BillingInstructionImpl(BillingInstructionBuilder builder) {
            this.sendingParty = Optional.ofNullable(builder.getSendingParty()).map(f -> f.build()).orElse(null);
            this.receivingParty = Optional.ofNullable(builder.getReceivingParty()).map(f -> f.build()).orElse(null);
            this.billingStartDate = builder.getBillingStartDate();
            this.billingEndDate = builder.getBillingEndDate();
            this.billingRecordInstruction = Optional.ofNullable(builder.getBillingRecordInstruction()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.billingSummary = Optional.ofNullable(builder.getBillingSummary()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="sendingParty", isRequired=true)
        @RuneAttribute(value="sendingParty", isRequired=true)
        public Party getSendingParty() {
            return this.sendingParty;
        }

        @Override
        @RosettaAttribute(value="receivingParty", isRequired=true)
        @RuneAttribute(value="receivingParty", isRequired=true)
        public Party getReceivingParty() {
            return this.receivingParty;
        }

        @Override
        @RosettaAttribute(value="billingStartDate", isRequired=true)
        @RuneAttribute(value="billingStartDate", isRequired=true)
        public Date getBillingStartDate() {
            return this.billingStartDate;
        }

        @Override
        @RosettaAttribute(value="billingEndDate", isRequired=true)
        @RuneAttribute(value="billingEndDate", isRequired=true)
        public Date getBillingEndDate() {
            return this.billingEndDate;
        }

        @Override
        @RosettaAttribute(value="billingRecordInstruction", isRequired=true)
        @RuneAttribute(value="billingRecordInstruction", isRequired=true)
        public List<? extends BillingRecordInstruction> getBillingRecordInstruction() {
            return this.billingRecordInstruction;
        }

        @Override
        @RosettaAttribute(value="billingSummary")
        @RuneAttribute(value="billingSummary")
        public List<? extends BillingSummaryInstruction> getBillingSummary() {
            return this.billingSummary;
        }

        @Override
        public BillingInstruction build() {
            return this;
        }

        @Override
        public BillingInstructionBuilder toBuilder() {
            BillingInstructionBuilder builder = BillingInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BillingInstructionBuilder builder) {
            Optional.ofNullable(this.getSendingParty()).ifPresent(builder::setSendingParty);
            Optional.ofNullable(this.getReceivingParty()).ifPresent(builder::setReceivingParty);
            Optional.ofNullable(this.getBillingStartDate()).ifPresent(builder::setBillingStartDate);
            Optional.ofNullable(this.getBillingEndDate()).ifPresent(builder::setBillingEndDate);
            Optional.ofNullable(this.getBillingRecordInstruction()).ifPresent(builder::setBillingRecordInstruction);
            Optional.ofNullable(this.getBillingSummary()).ifPresent(builder::setBillingSummary);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BillingInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.sendingParty, _that.getSendingParty())) {
                return false;
            }
            if (!Objects.equals(this.receivingParty, _that.getReceivingParty())) {
                return false;
            }
            if (!Objects.equals(this.billingStartDate, _that.getBillingStartDate())) {
                return false;
            }
            if (!Objects.equals(this.billingEndDate, _that.getBillingEndDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.billingRecordInstruction, _that.getBillingRecordInstruction())) {
                return false;
            }
            return ListEquals.listEquals(this.billingSummary, _that.getBillingSummary());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.sendingParty != null ? this.sendingParty.hashCode() : 0);
            _result = 31 * _result + (this.receivingParty != null ? this.receivingParty.hashCode() : 0);
            _result = 31 * _result + (this.billingStartDate != null ? this.billingStartDate.hashCode() : 0);
            _result = 31 * _result + (this.billingEndDate != null ? this.billingEndDate.hashCode() : 0);
            _result = 31 * _result + (this.billingRecordInstruction != null ? this.billingRecordInstruction.hashCode() : 0);
            _result = 31 * _result + (this.billingSummary != null ? this.billingSummary.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BillingInstruction {sendingParty=" + this.sendingParty + ", receivingParty=" + this.receivingParty + ", billingStartDate=" + this.billingStartDate + ", billingEndDate=" + this.billingEndDate + ", billingRecordInstruction=" + this.billingRecordInstruction + ", billingSummary=" + this.billingSummary + '}';
        }
    }
}

