/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.ArithmeticOperationEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=VectorOperationDefault.class)
public abstract class VectorOperation
implements RosettaFunction {
    public List<BigDecimal> evaluate(ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, List<BigDecimal> right) {
        List<BigDecimal> result = this.doEvaluate(arithmeticOp, left, right);
        return result;
    }

    protected abstract List<BigDecimal> doEvaluate(ArithmeticOperationEnum var1, List<BigDecimal> var2, List<BigDecimal> var3);

    public static class VectorOperationDefault
    extends VectorOperation {
        @Override
        protected List<BigDecimal> doEvaluate(ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, List<BigDecimal> right) {
            if (left == null) {
                left = Collections.emptyList();
            }
            if (right == null) {
                right = Collections.emptyList();
            }
            ArrayList<BigDecimal> result = new ArrayList<BigDecimal>();
            return this.assignOutput(result, arithmeticOp, left, right);
        }

        protected List<BigDecimal> assignOutput(List<BigDecimal> result, ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, List<BigDecimal> right) {
            return result;
        }
    }
}

