/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PayoutQuantity")
@ImplementedBy(value=Default.class)
public interface PayoutQuantity
extends Validator<Payout> {
    public static final String NAME = "PayoutQuantity";
    public static final String DEFINITION = "if optionPayout exists then optionPayout -> priceQuantity exists or optionPayout -> underlier -> contractualProduct -> economicTerms -> payout -> interestRatePayout count = 2";

    public ValidationResult<Payout> validate(RosettaPath var1, Payout var2);

    public static class NoOp
    implements PayoutQuantity {
        @Override
        public ValidationResult<Payout> validate(RosettaPath path, Payout payout) {
            return ValidationResult.success((String)PayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutQuantity.DEFINITION);
        }
    }

    public static class Default
    implements PayoutQuantity {
        @Override
        public ValidationResult<Payout> validate(RosettaPath path, Payout payout) {
            ComparisonResult result = this.executeDataRule(payout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutQuantity.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PayoutQuantity failed.";
            }
            return ValidationResult.failure((String)PayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutQuantity.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Payout payout) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).mapC("getOptionPayout", _payout -> _payout.getOptionPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).mapC("getOptionPayout", _payout -> _payout.getOptionPayout()).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity())).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperS.of((Object)payout).mapC("getOptionPayout", _payout -> _payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).resultCount()), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

