/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule.validation.datarule;

import cdm.product.common.schedule.PaymentDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PaymentDatesNonZeroPeriodMultiplier")
@ImplementedBy(value=Default.class)
public interface PaymentDatesNonZeroPeriodMultiplier
extends Validator<PaymentDates> {
    public static final String NAME = "PaymentDatesNonZeroPeriodMultiplier";
    public static final String DEFINITION = "if paymentDaysOffset exists then paymentDaysOffset -> periodMultiplier <> 0";

    public ValidationResult<PaymentDates> validate(RosettaPath var1, PaymentDates var2);

    public static class NoOp
    implements PaymentDatesNonZeroPeriodMultiplier {
        @Override
        public ValidationResult<PaymentDates> validate(RosettaPath path, PaymentDates paymentDates) {
            return ValidationResult.success((String)PaymentDatesNonZeroPeriodMultiplier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PaymentDates", (RosettaPath)path, (String)PaymentDatesNonZeroPeriodMultiplier.DEFINITION);
        }
    }

    public static class Default
    implements PaymentDatesNonZeroPeriodMultiplier {
        @Override
        public ValidationResult<PaymentDates> validate(RosettaPath path, PaymentDates paymentDates) {
            ComparisonResult result = this.executeDataRule(paymentDates);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PaymentDatesNonZeroPeriodMultiplier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PaymentDates", (RosettaPath)path, (String)PaymentDatesNonZeroPeriodMultiplier.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PaymentDatesNonZeroPeriodMultiplier failed.";
            }
            return ValidationResult.failure((String)PaymentDatesNonZeroPeriodMultiplier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PaymentDates", (RosettaPath)path, (String)PaymentDatesNonZeroPeriodMultiplier.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PaymentDates paymentDates) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)paymentDates).map("getPaymentDaysOffset", _paymentDates -> _paymentDates.getPaymentDaysOffset())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notEqual((Mapper)MapperS.of((Object)paymentDates).map("getPaymentDaysOffset", _paymentDates -> _paymentDates.getPaymentDaysOffset()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.Any);
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

