/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.functions;

import cdm.product.collateral.CheckEligibilityResult;
import cdm.product.collateral.EligibleCollateralSpecification;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CheckEligibilityForProductDefault.class)
public abstract class CheckEligibilityForProduct
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public CheckEligibilityResult evaluate(List<? extends EligibleCollateralSpecification> specifications, Product product) {
        CheckEligibilityResult eligibilityResult;
        CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResultBuilder = this.doEvaluate(specifications, product);
        if (eligibilityResultBuilder == null) {
            eligibilityResult = null;
        } else {
            eligibilityResult = eligibilityResultBuilder.build();
            this.objectValidator.validate(CheckEligibilityResult.class, (RosettaModelObject)eligibilityResult);
        }
        return eligibilityResult;
    }

    protected abstract CheckEligibilityResult.CheckEligibilityResultBuilder doEvaluate(List<? extends EligibleCollateralSpecification> var1, Product var2);

    public static class CheckEligibilityForProductDefault
    extends CheckEligibilityForProduct {
        @Override
        protected CheckEligibilityResult.CheckEligibilityResultBuilder doEvaluate(List<? extends EligibleCollateralSpecification> specifications, Product product) {
            CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResult = CheckEligibilityResult.builder();
            return this.assignOutput(eligibilityResult, specifications, product);
        }

        protected CheckEligibilityResult.CheckEligibilityResultBuilder assignOutput(CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResult, List<? extends EligibleCollateralSpecification> specifications, Product product) {
            return Optional.ofNullable(eligibilityResult).map(o -> o.prune()).orElse(null);
        }
    }
}

