/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.VarianceCapFloor;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="VarianceCapFloorCapFloorApplicability")
@ImplementedBy(value=Default.class)
public interface VarianceCapFloorCapFloorApplicability
extends Validator<VarianceCapFloor> {
    public static final String NAME = "VarianceCapFloorCapFloorApplicability";
    public static final String DEFINITION = "if varianceCap = True then unadjustedVarianceCap exists or boundedVariance exists else unadjustedVarianceCap is absent and boundedVariance is absent";

    public ValidationResult<VarianceCapFloor> validate(RosettaPath var1, VarianceCapFloor var2);

    public static class NoOp
    implements VarianceCapFloorCapFloorApplicability {
        @Override
        public ValidationResult<VarianceCapFloor> validate(RosettaPath path, VarianceCapFloor varianceCapFloor) {
            return ValidationResult.success((String)VarianceCapFloorCapFloorApplicability.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"VarianceCapFloor", (RosettaPath)path, (String)VarianceCapFloorCapFloorApplicability.DEFINITION);
        }
    }

    public static class Default
    implements VarianceCapFloorCapFloorApplicability {
        @Override
        public ValidationResult<VarianceCapFloor> validate(RosettaPath path, VarianceCapFloor varianceCapFloor) {
            ComparisonResult result = this.executeDataRule(varianceCapFloor);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)VarianceCapFloorCapFloorApplicability.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"VarianceCapFloor", (RosettaPath)path, (String)VarianceCapFloorCapFloorApplicability.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition VarianceCapFloorCapFloorApplicability failed.";
            }
            return ValidationResult.failure((String)VarianceCapFloorCapFloorApplicability.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"VarianceCapFloor", (RosettaPath)path, (String)VarianceCapFloorCapFloorApplicability.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(VarianceCapFloor varianceCapFloor) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)varianceCapFloor).map("getVarianceCap", _varianceCapFloor -> _varianceCapFloor.getVarianceCap()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)varianceCapFloor).map("getUnadjustedVarianceCap", _varianceCapFloor -> _varianceCapFloor.getUnadjustedVarianceCap())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)varianceCapFloor).map("getBoundedVariance", _varianceCapFloor -> _varianceCapFloor.getBoundedVariance())));
                    }
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)varianceCapFloor).map("getUnadjustedVarianceCap", _varianceCapFloor -> _varianceCapFloor.getUnadjustedVarianceCap())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)varianceCapFloor).map("getBoundedVariance", _varianceCapFloor -> _varianceCapFloor.getBoundedVariance())));
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

