/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.BoundedVariance;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="BoundedVarianceNonNegativeBarriers")
@ImplementedBy(value=Default.class)
public interface BoundedVarianceNonNegativeBarriers
extends Validator<BoundedVariance> {
    public static final String NAME = "BoundedVarianceNonNegativeBarriers";
    public static final String DEFINITION = "if upperBarrier exists then upperBarrier >= 0 and if lowerBarrier exists then lowerBarrier >= 0";

    public ValidationResult<BoundedVariance> validate(RosettaPath var1, BoundedVariance var2);

    public static class NoOp
    implements BoundedVarianceNonNegativeBarriers {
        @Override
        public ValidationResult<BoundedVariance> validate(RosettaPath path, BoundedVariance boundedVariance) {
            return ValidationResult.success((String)BoundedVarianceNonNegativeBarriers.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BoundedVariance", (RosettaPath)path, (String)BoundedVarianceNonNegativeBarriers.DEFINITION);
        }
    }

    public static class Default
    implements BoundedVarianceNonNegativeBarriers {
        @Override
        public ValidationResult<BoundedVariance> validate(RosettaPath path, BoundedVariance boundedVariance) {
            ComparisonResult result = this.executeDataRule(boundedVariance);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)BoundedVarianceNonNegativeBarriers.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BoundedVariance", (RosettaPath)path, (String)BoundedVarianceNonNegativeBarriers.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition BoundedVarianceNonNegativeBarriers failed.";
            }
            return ValidationResult.failure((String)BoundedVarianceNonNegativeBarriers.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BoundedVariance", (RosettaPath)path, (String)BoundedVarianceNonNegativeBarriers.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(BoundedVariance boundedVariance) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)boundedVariance).map("getUpperBarrier", _boundedVariance -> _boundedVariance.getUpperBarrier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)boundedVariance).map("getUpperBarrier", _boundedVariance -> _boundedVariance.getUpperBarrier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).and(MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)boundedVariance).map("getLowerBarrier", _boundedVariance -> _boundedVariance.getLowerBarrier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                                return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)boundedVariance).map("getLowerBarrier", _boundedVariance -> _boundedVariance.getLowerBarrier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All);
                            }
                            return null;
                        })));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

