/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.base.math.Rounding;
import cdm.observable.asset.Price;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.NegativeInterestRateTreatmentEnum;
import cdm.product.asset.RateTreatmentEnum;
import cdm.product.asset.floatingrate.FloatingRateProcessingParameters;
import cdm.product.asset.floatingrate.functions.CapRateAmount;
import cdm.product.asset.floatingrate.functions.FloorRateAmount;
import cdm.product.asset.floatingrate.functions.MultiplierAmount;
import cdm.product.asset.floatingrate.functions.SpreadAmount;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetFloatingRateProcessingParametersDefault.class)
public abstract class GetFloatingRateProcessingParameters
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CapRateAmount capRateAmount;
    @Inject
    protected FloorRateAmount floorRateAmount;
    @Inject
    protected MultiplierAmount multiplierAmount;
    @Inject
    protected SpreadAmount spreadAmount;

    public FloatingRateProcessingParameters evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
        FloatingRateProcessingParameters processingParameters;
        FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder processingParametersBuilder = this.doEvaluate(interestRatePayout, calculationPeriod);
        if (processingParametersBuilder == null) {
            processingParameters = null;
        } else {
            processingParameters = processingParametersBuilder.build();
            this.objectValidator.validate(FloatingRateProcessingParameters.class, (RosettaModelObject)processingParameters);
        }
        return processingParameters;
    }

    protected abstract FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract Mapper<BigDecimal> spreadRate(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract Mapper<BigDecimal> multiplier(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract Mapper<BigDecimal> cap(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract Mapper<BigDecimal> floor(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract Mapper<? extends Rounding> rounding(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract Mapper<NegativeInterestRateTreatmentEnum> negativeTreatment(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract Mapper<RateTreatmentEnum> treatment(InterestRatePayout var1, CalculationPeriodBase var2);

    public static class GetFloatingRateProcessingParametersDefault
    extends GetFloatingRateProcessingParameters {
        @Override
        protected FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder processingParameters = FloatingRateProcessingParameters.builder();
            return this.assignOutput(processingParameters, interestRatePayout, calculationPeriod);
        }

        protected FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder assignOutput(FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder processingParameters, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            processingParameters.setInitialRate((Price)MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getInitialRate", floatingRateSpecification -> floatingRateSpecification.getInitialRate()).get());
            processingParameters.setSpread((BigDecimal)MapperS.of((Object)((BigDecimal)this.spreadRate(interestRatePayout, calculationPeriod).get())).get());
            processingParameters.setMultiplier((BigDecimal)MapperS.of((Object)((BigDecimal)this.multiplier(interestRatePayout, calculationPeriod).get())).get());
            processingParameters.setTreatment((RateTreatmentEnum)((Object)MapperS.of((Object)((Object)((RateTreatmentEnum)((Object)this.treatment(interestRatePayout, calculationPeriod).get())))).get()));
            processingParameters.setCapRate((BigDecimal)MapperS.of((Object)((BigDecimal)this.cap(interestRatePayout, calculationPeriod).get())).get());
            processingParameters.setFloorRate((BigDecimal)MapperS.of((Object)((BigDecimal)this.floor(interestRatePayout, calculationPeriod).get())).get());
            processingParameters.setRounding((Rounding)MapperS.of((Object)((Rounding)this.rounding(interestRatePayout, calculationPeriod).get())).get());
            processingParameters.setNegativeTreatment((NegativeInterestRateTreatmentEnum)((Object)MapperS.of((Object)((Object)((NegativeInterestRateTreatmentEnum)((Object)this.negativeTreatment(interestRatePayout, calculationPeriod).get())))).get()));
            return Optional.ofNullable(processingParameters).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<BigDecimal> spreadRate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.spreadAmount.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
        }

        @Override
        protected Mapper<BigDecimal> multiplier(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.multiplierAmount.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
        }

        @Override
        protected Mapper<BigDecimal> cap(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.capRateAmount.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
        }

        @Override
        protected Mapper<BigDecimal> floor(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.floorRateAmount.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
        }

        @Override
        protected Mapper<? extends Rounding> rounding(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getFinalRateRounding", floatingRateSpecification -> floatingRateSpecification.getFinalRateRounding());
        }

        @Override
        protected Mapper<NegativeInterestRateTreatmentEnum> negativeTreatment(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getNegativeInterestRateTreatment", floatingRateSpecification -> floatingRateSpecification.getNegativeInterestRateTreatment());
        }

        @Override
        protected Mapper<RateTreatmentEnum> treatment(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateTreatment", floatingRate -> floatingRate.getRateTreatment());
        }
    }
}

