/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.product.asset.floatingrate.FloatingRateProcessingDetails;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=DefaultFloatingRateDefault.class)
public abstract class DefaultFloatingRate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public FloatingRateProcessingDetails evaluate(BigDecimal suppliedRate) {
        FloatingRateProcessingDetails processedRateDetails;
        FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder processedRateDetailsBuilder = this.doEvaluate(suppliedRate);
        if (processedRateDetailsBuilder == null) {
            processedRateDetails = null;
        } else {
            processedRateDetails = processedRateDetailsBuilder.build();
            this.objectValidator.validate(FloatingRateProcessingDetails.class, (RosettaModelObject)processedRateDetails);
        }
        return processedRateDetails;
    }

    protected abstract FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder doEvaluate(BigDecimal var1);

    public static class DefaultFloatingRateDefault
    extends DefaultFloatingRate {
        @Override
        protected FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder doEvaluate(BigDecimal suppliedRate) {
            FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder processedRateDetails = FloatingRateProcessingDetails.builder();
            return this.assignOutput(processedRateDetails, suppliedRate);
        }

        protected FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder assignOutput(FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder processedRateDetails, BigDecimal suppliedRate) {
            processedRateDetails.setProcessedRate((BigDecimal)MapperS.of((Object)suppliedRate).get());
            return Optional.ofNullable(processedRateDetails).map(o -> o.prune()).orElse(null);
        }
    }
}

