/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="LoadTypeEnum")
public enum LoadTypeEnum {
    BASE_LOAD("BaseLoad"),
    PEAK_LOAD("PeakLoad"),
    OFF_PEAK("OffPeak"),
    BLOCK_HOURS("BlockHours"),
    SHAPED("Shaped"),
    GAS_DAY("GasDay"),
    OTHER("Other");

    private static Map<String, LoadTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private LoadTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private LoadTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static LoadTypeEnum fromDisplayName(String name) {
        LoadTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, LoadTypeEnum> map = new ConcurrentHashMap<String, LoadTypeEnum>();
        for (LoadTypeEnum instance : LoadTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

