/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate;

import cdm.base.datetime.BusinessCenters;
import cdm.observable.asset.calculatedrate.CalculationMethodEnum;
import cdm.observable.asset.calculatedrate.ObservationParameters;
import cdm.observable.asset.calculatedrate.ObservationShiftCalculation;
import cdm.observable.asset.calculatedrate.OffsetCalculation;
import cdm.observable.asset.calculatedrate.meta.FloatingRateCalculationParametersMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FloatingRateCalculationParameters", builder=FloatingRateCalculationParametersBuilderImpl.class, version="5.0.0")
public interface FloatingRateCalculationParameters
extends RosettaModelObject {
    public static final FloatingRateCalculationParametersMeta metaData = new FloatingRateCalculationParametersMeta();

    public CalculationMethodEnum getCalculationMethod();

    public ObservationShiftCalculation getObservationShiftCalculation();

    public OffsetCalculation getLookbackCalculation();

    public OffsetCalculation getLockoutCalculation();

    public BusinessCenters getApplicableBusinessDays();

    public ObservationParameters getObservationParameters();

    public FloatingRateCalculationParameters build();

    public FloatingRateCalculationParametersBuilder toBuilder();

    public static FloatingRateCalculationParametersBuilder builder() {
        return new FloatingRateCalculationParametersBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingRateCalculationParameters> metaData() {
        return metaData;
    }

    default public Class<? extends FloatingRateCalculationParameters> getType() {
        return FloatingRateCalculationParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("calculationMethod"), CalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationShiftCalculation"), processor, ObservationShiftCalculation.class, this.getObservationShiftCalculation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lookbackCalculation"), processor, OffsetCalculation.class, this.getLookbackCalculation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lockoutCalculation"), processor, OffsetCalculation.class, this.getLockoutCalculation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("applicableBusinessDays"), processor, BusinessCenters.class, this.getApplicableBusinessDays(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationParameters"), processor, ObservationParameters.class, this.getObservationParameters(), new AttributeMeta[0]);
    }

    public static class FloatingRateCalculationParametersBuilderImpl
    implements FloatingRateCalculationParametersBuilder {
        protected CalculationMethodEnum calculationMethod;
        protected ObservationShiftCalculation.ObservationShiftCalculationBuilder observationShiftCalculation;
        protected OffsetCalculation.OffsetCalculationBuilder lookbackCalculation;
        protected OffsetCalculation.OffsetCalculationBuilder lockoutCalculation;
        protected BusinessCenters.BusinessCentersBuilder applicableBusinessDays;
        protected ObservationParameters.ObservationParametersBuilder observationParameters;

        @Override
        @RosettaAttribute(value="calculationMethod")
        public CalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="observationShiftCalculation")
        public ObservationShiftCalculation.ObservationShiftCalculationBuilder getObservationShiftCalculation() {
            return this.observationShiftCalculation;
        }

        @Override
        public ObservationShiftCalculation.ObservationShiftCalculationBuilder getOrCreateObservationShiftCalculation() {
            ObservationShiftCalculation.ObservationShiftCalculationBuilder result = this.observationShiftCalculation != null ? this.observationShiftCalculation : (this.observationShiftCalculation = ObservationShiftCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lookbackCalculation")
        public OffsetCalculation.OffsetCalculationBuilder getLookbackCalculation() {
            return this.lookbackCalculation;
        }

        @Override
        public OffsetCalculation.OffsetCalculationBuilder getOrCreateLookbackCalculation() {
            OffsetCalculation.OffsetCalculationBuilder result = this.lookbackCalculation != null ? this.lookbackCalculation : (this.lookbackCalculation = OffsetCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lockoutCalculation")
        public OffsetCalculation.OffsetCalculationBuilder getLockoutCalculation() {
            return this.lockoutCalculation;
        }

        @Override
        public OffsetCalculation.OffsetCalculationBuilder getOrCreateLockoutCalculation() {
            OffsetCalculation.OffsetCalculationBuilder result = this.lockoutCalculation != null ? this.lockoutCalculation : (this.lockoutCalculation = OffsetCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="applicableBusinessDays")
        public BusinessCenters.BusinessCentersBuilder getApplicableBusinessDays() {
            return this.applicableBusinessDays;
        }

        @Override
        public BusinessCenters.BusinessCentersBuilder getOrCreateApplicableBusinessDays() {
            BusinessCenters.BusinessCentersBuilder result = this.applicableBusinessDays != null ? this.applicableBusinessDays : (this.applicableBusinessDays = BusinessCenters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationParameters")
        public ObservationParameters.ObservationParametersBuilder getObservationParameters() {
            return this.observationParameters;
        }

        @Override
        public ObservationParameters.ObservationParametersBuilder getOrCreateObservationParameters() {
            ObservationParameters.ObservationParametersBuilder result = this.observationParameters != null ? this.observationParameters : (this.observationParameters = ObservationParameters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationMethod")
        public FloatingRateCalculationParametersBuilder setCalculationMethod(CalculationMethodEnum calculationMethod) {
            this.calculationMethod = calculationMethod == null ? null : calculationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="observationShiftCalculation")
        public FloatingRateCalculationParametersBuilder setObservationShiftCalculation(ObservationShiftCalculation observationShiftCalculation) {
            this.observationShiftCalculation = observationShiftCalculation == null ? null : observationShiftCalculation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lookbackCalculation")
        public FloatingRateCalculationParametersBuilder setLookbackCalculation(OffsetCalculation lookbackCalculation) {
            this.lookbackCalculation = lookbackCalculation == null ? null : lookbackCalculation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lockoutCalculation")
        public FloatingRateCalculationParametersBuilder setLockoutCalculation(OffsetCalculation lockoutCalculation) {
            this.lockoutCalculation = lockoutCalculation == null ? null : lockoutCalculation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="applicableBusinessDays")
        public FloatingRateCalculationParametersBuilder setApplicableBusinessDays(BusinessCenters applicableBusinessDays) {
            this.applicableBusinessDays = applicableBusinessDays == null ? null : applicableBusinessDays.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationParameters")
        public FloatingRateCalculationParametersBuilder setObservationParameters(ObservationParameters observationParameters) {
            this.observationParameters = observationParameters == null ? null : observationParameters.toBuilder();
            return this;
        }

        @Override
        public FloatingRateCalculationParameters build() {
            return new FloatingRateCalculationParametersImpl(this);
        }

        @Override
        public FloatingRateCalculationParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateCalculationParametersBuilder prune() {
            if (this.observationShiftCalculation != null && !this.observationShiftCalculation.prune().hasData()) {
                this.observationShiftCalculation = null;
            }
            if (this.lookbackCalculation != null && !this.lookbackCalculation.prune().hasData()) {
                this.lookbackCalculation = null;
            }
            if (this.lockoutCalculation != null && !this.lockoutCalculation.prune().hasData()) {
                this.lockoutCalculation = null;
            }
            if (this.applicableBusinessDays != null && !this.applicableBusinessDays.prune().hasData()) {
                this.applicableBusinessDays = null;
            }
            if (this.observationParameters != null && !this.observationParameters.prune().hasData()) {
                this.observationParameters = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCalculationMethod() != null) {
                return true;
            }
            if (this.getObservationShiftCalculation() != null && this.getObservationShiftCalculation().hasData()) {
                return true;
            }
            if (this.getLookbackCalculation() != null && this.getLookbackCalculation().hasData()) {
                return true;
            }
            if (this.getLockoutCalculation() != null && this.getLockoutCalculation().hasData()) {
                return true;
            }
            if (this.getApplicableBusinessDays() != null && this.getApplicableBusinessDays().hasData()) {
                return true;
            }
            return this.getObservationParameters() != null && this.getObservationParameters().hasData();
        }

        public FloatingRateCalculationParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FloatingRateCalculationParametersBuilder o = (FloatingRateCalculationParametersBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationShiftCalculation(), (RosettaModelObjectBuilder)o.getObservationShiftCalculation(), this::setObservationShiftCalculation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLookbackCalculation(), (RosettaModelObjectBuilder)o.getLookbackCalculation(), this::setLookbackCalculation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLockoutCalculation(), (RosettaModelObjectBuilder)o.getLockoutCalculation(), this::setLockoutCalculation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApplicableBusinessDays(), (RosettaModelObjectBuilder)o.getApplicableBusinessDays(), this::setApplicableBusinessDays);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationParameters(), (RosettaModelObjectBuilder)o.getObservationParameters(), this::setObservationParameters);
            merger.mergeBasic((Object)this.getCalculationMethod(), (Object)o.getCalculationMethod(), this::setCalculationMethod, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateCalculationParameters _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.observationShiftCalculation, _that.getObservationShiftCalculation())) {
                return false;
            }
            if (!Objects.equals(this.lookbackCalculation, _that.getLookbackCalculation())) {
                return false;
            }
            if (!Objects.equals(this.lockoutCalculation, _that.getLockoutCalculation())) {
                return false;
            }
            if (!Objects.equals(this.applicableBusinessDays, _that.getApplicableBusinessDays())) {
                return false;
            }
            return Objects.equals(this.observationParameters, _that.getObservationParameters());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.observationShiftCalculation != null ? this.observationShiftCalculation.hashCode() : 0);
            _result = 31 * _result + (this.lookbackCalculation != null ? this.lookbackCalculation.hashCode() : 0);
            _result = 31 * _result + (this.lockoutCalculation != null ? this.lockoutCalculation.hashCode() : 0);
            _result = 31 * _result + (this.applicableBusinessDays != null ? this.applicableBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.observationParameters != null ? this.observationParameters.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateCalculationParametersBuilder {calculationMethod=" + (Object)((Object)this.calculationMethod) + ", observationShiftCalculation=" + this.observationShiftCalculation + ", lookbackCalculation=" + this.lookbackCalculation + ", lockoutCalculation=" + this.lockoutCalculation + ", applicableBusinessDays=" + this.applicableBusinessDays + ", observationParameters=" + this.observationParameters + '}';
        }
    }

    public static class FloatingRateCalculationParametersImpl
    implements FloatingRateCalculationParameters {
        private final CalculationMethodEnum calculationMethod;
        private final ObservationShiftCalculation observationShiftCalculation;
        private final OffsetCalculation lookbackCalculation;
        private final OffsetCalculation lockoutCalculation;
        private final BusinessCenters applicableBusinessDays;
        private final ObservationParameters observationParameters;

        protected FloatingRateCalculationParametersImpl(FloatingRateCalculationParametersBuilder builder) {
            this.calculationMethod = builder.getCalculationMethod();
            this.observationShiftCalculation = Optional.ofNullable(builder.getObservationShiftCalculation()).map(f -> f.build()).orElse(null);
            this.lookbackCalculation = Optional.ofNullable(builder.getLookbackCalculation()).map(f -> f.build()).orElse(null);
            this.lockoutCalculation = Optional.ofNullable(builder.getLockoutCalculation()).map(f -> f.build()).orElse(null);
            this.applicableBusinessDays = Optional.ofNullable(builder.getApplicableBusinessDays()).map(f -> f.build()).orElse(null);
            this.observationParameters = Optional.ofNullable(builder.getObservationParameters()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="calculationMethod")
        public CalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="observationShiftCalculation")
        public ObservationShiftCalculation getObservationShiftCalculation() {
            return this.observationShiftCalculation;
        }

        @Override
        @RosettaAttribute(value="lookbackCalculation")
        public OffsetCalculation getLookbackCalculation() {
            return this.lookbackCalculation;
        }

        @Override
        @RosettaAttribute(value="lockoutCalculation")
        public OffsetCalculation getLockoutCalculation() {
            return this.lockoutCalculation;
        }

        @Override
        @RosettaAttribute(value="applicableBusinessDays")
        public BusinessCenters getApplicableBusinessDays() {
            return this.applicableBusinessDays;
        }

        @Override
        @RosettaAttribute(value="observationParameters")
        public ObservationParameters getObservationParameters() {
            return this.observationParameters;
        }

        @Override
        public FloatingRateCalculationParameters build() {
            return this;
        }

        @Override
        public FloatingRateCalculationParametersBuilder toBuilder() {
            FloatingRateCalculationParametersBuilder builder = FloatingRateCalculationParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateCalculationParametersBuilder builder) {
            Optional.ofNullable(this.getCalculationMethod()).ifPresent(builder::setCalculationMethod);
            Optional.ofNullable(this.getObservationShiftCalculation()).ifPresent(builder::setObservationShiftCalculation);
            Optional.ofNullable(this.getLookbackCalculation()).ifPresent(builder::setLookbackCalculation);
            Optional.ofNullable(this.getLockoutCalculation()).ifPresent(builder::setLockoutCalculation);
            Optional.ofNullable(this.getApplicableBusinessDays()).ifPresent(builder::setApplicableBusinessDays);
            Optional.ofNullable(this.getObservationParameters()).ifPresent(builder::setObservationParameters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateCalculationParameters _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.observationShiftCalculation, _that.getObservationShiftCalculation())) {
                return false;
            }
            if (!Objects.equals(this.lookbackCalculation, _that.getLookbackCalculation())) {
                return false;
            }
            if (!Objects.equals(this.lockoutCalculation, _that.getLockoutCalculation())) {
                return false;
            }
            if (!Objects.equals(this.applicableBusinessDays, _that.getApplicableBusinessDays())) {
                return false;
            }
            return Objects.equals(this.observationParameters, _that.getObservationParameters());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.observationShiftCalculation != null ? this.observationShiftCalculation.hashCode() : 0);
            _result = 31 * _result + (this.lookbackCalculation != null ? this.lookbackCalculation.hashCode() : 0);
            _result = 31 * _result + (this.lockoutCalculation != null ? this.lockoutCalculation.hashCode() : 0);
            _result = 31 * _result + (this.applicableBusinessDays != null ? this.applicableBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.observationParameters != null ? this.observationParameters.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateCalculationParameters {calculationMethod=" + (Object)((Object)this.calculationMethod) + ", observationShiftCalculation=" + this.observationShiftCalculation + ", lookbackCalculation=" + this.lookbackCalculation + ", lockoutCalculation=" + this.lockoutCalculation + ", applicableBusinessDays=" + this.applicableBusinessDays + ", observationParameters=" + this.observationParameters + '}';
        }
    }

    public static interface FloatingRateCalculationParametersBuilder
    extends FloatingRateCalculationParameters,
    RosettaModelObjectBuilder {
        public ObservationShiftCalculation.ObservationShiftCalculationBuilder getOrCreateObservationShiftCalculation();

        @Override
        public ObservationShiftCalculation.ObservationShiftCalculationBuilder getObservationShiftCalculation();

        public OffsetCalculation.OffsetCalculationBuilder getOrCreateLookbackCalculation();

        @Override
        public OffsetCalculation.OffsetCalculationBuilder getLookbackCalculation();

        public OffsetCalculation.OffsetCalculationBuilder getOrCreateLockoutCalculation();

        @Override
        public OffsetCalculation.OffsetCalculationBuilder getLockoutCalculation();

        public BusinessCenters.BusinessCentersBuilder getOrCreateApplicableBusinessDays();

        @Override
        public BusinessCenters.BusinessCentersBuilder getApplicableBusinessDays();

        public ObservationParameters.ObservationParametersBuilder getOrCreateObservationParameters();

        @Override
        public ObservationParameters.ObservationParametersBuilder getObservationParameters();

        public FloatingRateCalculationParametersBuilder setCalculationMethod(CalculationMethodEnum var1);

        public FloatingRateCalculationParametersBuilder setObservationShiftCalculation(ObservationShiftCalculation var1);

        public FloatingRateCalculationParametersBuilder setLookbackCalculation(OffsetCalculation var1);

        public FloatingRateCalculationParametersBuilder setLockoutCalculation(OffsetCalculation var1);

        public FloatingRateCalculationParametersBuilder setApplicableBusinessDays(BusinessCenters var1);

        public FloatingRateCalculationParametersBuilder setObservationParameters(ObservationParameters var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("calculationMethod"), CalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationShiftCalculation"), processor, ObservationShiftCalculation.ObservationShiftCalculationBuilder.class, this.getObservationShiftCalculation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lookbackCalculation"), processor, OffsetCalculation.OffsetCalculationBuilder.class, this.getLookbackCalculation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lockoutCalculation"), processor, OffsetCalculation.OffsetCalculationBuilder.class, this.getLockoutCalculation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("applicableBusinessDays"), processor, BusinessCenters.BusinessCentersBuilder.class, this.getApplicableBusinessDays(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationParameters"), processor, ObservationParameters.ObservationParametersBuilder.class, this.getObservationParameters(), new AttributeMeta[0]);
        }

        public FloatingRateCalculationParametersBuilder prune();
    }
}

