/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.UnitType;
import cdm.event.common.EventIntentEnum;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.TradeState;
import cdm.event.workflow.EventInstruction;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveRepurchaseTransferInstructionDefault.class)
public abstract class ResolveRepurchaseTransferInstruction
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public EventInstruction evaluate(TradeState tradeState, Date repurchaseDate) {
        EventInstruction repurchaseInstruction;
        EventInstruction.EventInstructionBuilder repurchaseInstructionBuilder = this.doEvaluate(tradeState, repurchaseDate);
        if (repurchaseInstructionBuilder == null) {
            repurchaseInstruction = null;
        } else {
            repurchaseInstruction = repurchaseInstructionBuilder.build();
            this.objectValidator.validate(EventInstruction.class, (RosettaModelObject)repurchaseInstruction);
        }
        return repurchaseInstruction;
    }

    protected abstract EventInstruction.EventInstructionBuilder doEvaluate(TradeState var1, Date var2);

    protected abstract Mapper<? extends NonNegativeQuantitySchedule> changeQuantity(TradeState var1, Date var2);

    protected abstract Mapper<? extends PriceQuantity> changePriceQuantity(TradeState var1, Date var2);

    public static class ResolveRepurchaseTransferInstructionDefault
    extends ResolveRepurchaseTransferInstruction {
        @Override
        protected EventInstruction.EventInstructionBuilder doEvaluate(TradeState tradeState, Date repurchaseDate) {
            EventInstruction.EventInstructionBuilder repurchaseInstruction = EventInstruction.builder();
            return this.assignOutput(repurchaseInstruction, tradeState, repurchaseDate);
        }

        protected EventInstruction.EventInstructionBuilder assignOutput(EventInstruction.EventInstructionBuilder repurchaseInstruction, TradeState tradeState, Date repurchaseDate) {
            repurchaseInstruction.setIntent((EventIntentEnum)((Object)MapperS.of((Object)((Object)EventIntentEnum.REPURCHASE)).get()));
            repurchaseInstruction.getOrCreateInstruction(0).setBeforeValue((TradeState)MapperS.of((Object)tradeState).get());
            repurchaseInstruction.getOrCreateInstruction(0).getOrCreatePrimitiveInstruction().setQuantityChange((QuantityChangeInstruction)MapperS.of((Object)QuantityChangeInstruction.builder().setChange(MapperS.of((Object)((PriceQuantity)this.changePriceQuantity(tradeState, repurchaseDate).get())).getMulti()).setDirection((QuantityChangeDirectionEnum)((Object)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.REPLACE)).get())).setLotIdentifier(MapperC.ofNull().getMulti()).build()).get());
            return Optional.ofNullable(repurchaseInstruction).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends NonNegativeQuantitySchedule> changeQuantity(TradeState tradeState, Date repurchaseDate) {
            return (Mapper)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue()).mapItem(item -> MapperS.of((Object)NonNegativeQuantitySchedule.builder().setValue((BigDecimal)MapperS.of((Object)new BigDecimal("0.0")).get()).setUnit((UnitType)item.map("getUnit", measureBase -> measureBase.getUnit()).get()).build())).apply(item -> ExpressionOperators.distinct((Mapper)item));
        }

        @Override
        protected Mapper<? extends PriceQuantity> changePriceQuantity(TradeState tradeState, Date repurchaseDate) {
            return MapperS.of((Object)PriceQuantity.builder().setQuantityValue(MapperC.of((List)this.changeQuantity(tradeState, repurchaseDate).getMulti()).getMulti()).build());
        }
    }
}

