/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.common.Instruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.FilterClosedTradeStates;
import cdm.event.common.functions.FilterOpenTradeStates;
import cdm.observable.asset.Observable;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.EconomicTerms;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=Qualify_OnDemandRateChangeDefault.class)
public abstract class Qualify_OnDemandRateChange
implements RosettaFunction,
IQualifyFunctionExtension<BusinessEvent> {
    @Inject
    protected FilterClosedTradeStates filterClosedTradeStates;
    @Inject
    protected FilterOpenTradeStates filterOpenTradeStates;

    public Boolean evaluate(BusinessEvent businessEvent) {
        Boolean is_event = this.doEvaluate(businessEvent);
        return is_event;
    }

    protected abstract Boolean doEvaluate(BusinessEvent var1);

    protected abstract Mapper<? extends TradableProduct> beforeTradableProduct(BusinessEvent var1);

    protected abstract Mapper<? extends EconomicTerms> beforeEconomicterms(BusinessEvent var1);

    protected abstract Mapper<? extends TradableProduct> openTradableProduct(BusinessEvent var1);

    protected abstract Mapper<? extends EconomicTerms> openEconomicTerms(BusinessEvent var1);

    protected abstract Mapper<? extends TradeState> closedTradeState(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> beforePriceQuantityRateOnly(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> openPriceQuantityRateOnly(BusinessEvent var1);

    protected abstract Mapper<? extends PriceQuantity> beforePriceQuantityNoRate(BusinessEvent var1);

    protected abstract Mapper<? extends PriceQuantity> openPriceQuantityNoRate(BusinessEvent var1);

    public String getNamePrefix() {
        return "Qualify";
    }

    public static class Qualify_OnDemandRateChangeDefault
    extends Qualify_OnDemandRateChange {
        @Override
        protected Boolean doEvaluate(BusinessEvent businessEvent) {
            Boolean is_event = null;
            return this.assignOutput(is_event, businessEvent);
        }

        protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
            is_event = ExpressionOperators.exists((Mapper)MapperS.of((Object)((EconomicTerms)this.beforeEconomicterms(businessEvent).get()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((EconomicTerms)this.openEconomicTerms(businessEvent).get())))).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperC.of((List)this.closedTradeState(businessEvent).getMulti()).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((EconomicTerms)this.openEconomicTerms(businessEvent).get())).map("getCollateral", economicTerms -> economicTerms.getCollateral()), (Mapper)MapperS.of((Object)((EconomicTerms)this.beforeEconomicterms(businessEvent).get())).map("getCollateral", economicTerms -> economicTerms.getCollateral()), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperC.of((List)this.beforePriceQuantityRateOnly(businessEvent).getMulti()).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperC.of((List)this.openPriceQuantityRateOnly(businessEvent).getMulti()).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)((BigDecimal)MapperC.of((List)this.beforePriceQuantityRateOnly(businessEvent).getMulti()).get())), (Mapper)MapperS.of((Object)((BigDecimal)MapperC.of((List)this.openPriceQuantityRateOnly(businessEvent).getMulti()).get())), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.areEqual((Mapper)MapperC.of((List)this.beforePriceQuantityNoRate(businessEvent).getMulti()), (Mapper)MapperC.of((List)this.openPriceQuantityNoRate(businessEvent).getMulti()), (CardinalityOperator)CardinalityOperator.All)).get();
            return is_event;
        }

        @Override
        protected Mapper<? extends TradableProduct> beforeTradableProduct(BusinessEvent businessEvent) {
            return MapperS.of((Object)((Instruction)MapperS.of((Object)businessEvent).mapC("getInstruction", eventInstruction -> eventInstruction.getInstruction()).get())).map("getBefore", instruction -> instruction.getBefore()).map("getValue", _f -> _f.getValue()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct());
        }

        @Override
        protected Mapper<? extends EconomicTerms> beforeEconomicterms(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradableProduct)this.beforeTradableProduct(businessEvent).get())).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms());
        }

        @Override
        protected Mapper<? extends TradableProduct> openTradableProduct(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeState)MapperC.of(this.filterOpenTradeStates.evaluate(MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti())).get())).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct());
        }

        @Override
        protected Mapper<? extends EconomicTerms> openEconomicTerms(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradableProduct)this.openTradableProduct(businessEvent).get())).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms());
        }

        @Override
        protected Mapper<? extends TradeState> closedTradeState(BusinessEvent businessEvent) {
            return MapperC.of(this.filterClosedTradeStates.evaluate(MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti()));
        }

        @Override
        protected Mapper<BigDecimal> beforePriceQuantityRateOnly(BusinessEvent businessEvent) {
            return (Mapper)((MapperC)((MapperC)MapperS.of((Object)((TradeLot)MapperS.of((Object)((TradableProduct)this.beforeTradableProduct(businessEvent).get())).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapItemToList(item -> item.mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue())).apply(item -> item.flattenList())).apply(item -> item.filterItemNullSafe(_item -> ExpressionOperators.areEqual((Mapper)_item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.All).get()))).apply(item -> item.mapItem(_item -> _item.map("getValue", measureBase -> measureBase.getValue())));
        }

        @Override
        protected Mapper<BigDecimal> openPriceQuantityRateOnly(BusinessEvent businessEvent) {
            return (Mapper)((MapperC)((MapperC)MapperS.of((Object)((TradeLot)MapperS.of((Object)((TradableProduct)this.openTradableProduct(businessEvent).get())).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapItemToList(item -> item.mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue())).apply(item -> item.flattenList())).apply(item -> item.filterItemNullSafe(_item -> ExpressionOperators.areEqual((Mapper)_item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.All).get()))).apply(item -> item.mapItem(_item -> _item.map("getValue", measureBase -> measureBase.getValue())));
        }

        @Override
        protected Mapper<? extends PriceQuantity> beforePriceQuantityNoRate(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeLot)MapperS.of((Object)((TradableProduct)this.beforeTradableProduct(businessEvent).get())).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapItem(item -> MapperS.of((Object)PriceQuantity.builder().setPriceValue(item.mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).filterItemNullSafe(p -> ExpressionOperators.notEqual((Mapper)p.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.Any).get()).getMulti()).setQuantityValue(item.mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue()).getMulti()).setObservable((Observable)item.map("getObservable", priceQuantity -> priceQuantity.getObservable()).get()).build()));
        }

        @Override
        protected Mapper<? extends PriceQuantity> openPriceQuantityNoRate(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeLot)MapperS.of((Object)((TradableProduct)this.openTradableProduct(businessEvent).get())).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapItem(item -> MapperS.of((Object)PriceQuantity.builder().setPriceValue(item.mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).filterItemNullSafe(p -> ExpressionOperators.notEqual((Mapper)p.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.Any).get()).getMulti()).setQuantityValue(item.mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue()).getMulti()).setObservable((Observable)item.map("getObservable", priceQuantity -> priceQuantity.getObservable()).get()).build()));
        }
    }
}

