/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.validation.datarule;

import cdm.base.math.MoneyRange;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="MoneyRangeAtLeastOneOf")
@ImplementedBy(value=Default.class)
public interface MoneyRangeAtLeastOneOf
extends Validator<MoneyRange> {
    public static final String NAME = "MoneyRangeAtLeastOneOf";
    public static final String DEFINITION = "lowerBound exists or upperBound exists";

    public ValidationResult<MoneyRange> validate(RosettaPath var1, MoneyRange var2);

    public static class NoOp
    implements MoneyRangeAtLeastOneOf {
        @Override
        public ValidationResult<MoneyRange> validate(RosettaPath path, MoneyRange moneyRange) {
            return ValidationResult.success((String)MoneyRangeAtLeastOneOf.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MoneyRange", (RosettaPath)path, (String)MoneyRangeAtLeastOneOf.DEFINITION);
        }
    }

    public static class Default
    implements MoneyRangeAtLeastOneOf {
        @Override
        public ValidationResult<MoneyRange> validate(RosettaPath path, MoneyRange moneyRange) {
            ComparisonResult result = this.executeDataRule(moneyRange);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)MoneyRangeAtLeastOneOf.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MoneyRange", (RosettaPath)path, (String)MoneyRangeAtLeastOneOf.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition MoneyRangeAtLeastOneOf failed.";
            }
            return ValidationResult.failure((String)MoneyRangeAtLeastOneOf.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MoneyRange", (RosettaPath)path, (String)MoneyRangeAtLeastOneOf.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(MoneyRange moneyRange) {
            try {
                ComparisonResult result = ExpressionOperators.exists((Mapper)MapperS.of((Object)moneyRange).map("getLowerBound", _moneyRange -> _moneyRange.getLowerBound())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)moneyRange).map("getUpperBound", _moneyRange -> _moneyRange.getUpperBound())));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

