# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['SecurityLocate']

from cdm.event.position.AvailableInventory import AvailableInventory

class SecurityLocate(AvailableInventory):
  """
  A locate is an approval from a broker that needs to be obtained prior to effecting a short sale in an equity security. Similar to security availability, a borrower can request a single or multiple securities, but at least one must be requested.
  """
  
  @rosetta_condition
  def condition_0_RequestOneSecurityMinimum(self):
    """
    A locate must request the availability of at least one security.
    """
    return ((_resolve_rosetta_attr(self, "availableInventoryRecord")) is not None)


SecurityLocate.update_forward_refs()
