# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['IndexReferenceInformation']


class IndexReferenceInformation(BaseDataClass):
  """
  A class defining information related to Index
  """
  indexName: Optional[AttributeWithMeta[str] | str] = Field(None, description="The name of the index expressed as a free format string with an associated scheme.")
  """
  The name of the index expressed as a free format string with an associated scheme.
  """
  indexId: List[AttributeWithMeta[str] | str] = Field([], description="An index identifier (e.g. RED pair code).")
  """
  An index identifier (e.g. RED pair code).
  """
  
  @rosetta_condition
  def condition_0_IndexAttributes(self):
    """
    A required choice condition for either a floating rate or inflation rate index.
    """
    return (((_resolve_rosetta_attr(self, "indexName")) is not None) or ((_resolve_rosetta_attr(self, "indexId")) is not None))


IndexReferenceInformation.update_forward_refs()
