package cdm.product.collateral.validation;

import cdm.product.collateral.CheckEligibilityResult;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CheckEligibilityResultTypeFormatValidator implements Validator<CheckEligibilityResult> {

	@Override
	public ValidationResult<CheckEligibilityResult> validate(RosettaPath path, CheckEligibilityResult o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CheckEligibilityResult", ValidationType.TYPE_FORMAT, "CheckEligibilityResult", path, "", error);
		}
		return success("CheckEligibilityResult", ValidationType.TYPE_FORMAT, "CheckEligibilityResult", path, "");
	}

}
