package cdm.legaldocumentation.common.validation.exists;

import cdm.base.staticdata.party.Counterparty;
import cdm.legaldocumentation.common.AgreementTerms;
import cdm.legaldocumentation.contract.Agreement;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class AgreementTermsOnlyExistsValidator implements ValidatorWithArg<AgreementTerms, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends AgreementTerms> ValidationResult<AgreementTerms> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("agreement", ExistenceChecker.isSet((Agreement) o.getAgreement()))
				.put("clauseLibrary", ExistenceChecker.isSet((Boolean) o.getClauseLibrary()))
				.put("counterparty", ExistenceChecker.isSet((List<? extends Counterparty>) o.getCounterparty()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("AgreementTerms", ValidationType.ONLY_EXISTS, "AgreementTerms", path, "");
		}
		return failure("AgreementTerms", ValidationType.ONLY_EXISTS, "AgreementTerms", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
