package cdm.event.common.validation;

import cdm.base.staticdata.identifier.Identifier;
import cdm.event.common.CollateralPortfolio;
import cdm.legaldocumentation.common.metafields.ReferenceWithMetaLegalAgreement;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CollateralPortfolioValidator implements Validator<CollateralPortfolio> {

	@Override
	public ValidationResult<CollateralPortfolio> validate(RosettaPath path, CollateralPortfolio o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("portfolioIdentifier", (Identifier) o.getPortfolioIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("legalAgreement", (ReferenceWithMetaLegalAgreement) o.getLegalAgreement() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CollateralPortfolio", ValidationType.CARDINALITY, "CollateralPortfolio", path, "", error);
		}
		return success("CollateralPortfolio", ValidationType.CARDINALITY, "CollateralPortfolio", path, "");
	}

}
