package cdm.event.common.functions;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.event.common.BusinessEvent;
import cdm.event.common.ExecutionDetails;
import cdm.event.common.Instruction;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Qualify_PairOff.Qualify_PairOffDefault.class)
public abstract class Qualify_PairOff implements RosettaFunction,IQualifyFunctionExtension<BusinessEvent> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FilterOpenTradeStates filterOpenTradeStates;
	@Inject protected NewTradeInstructionOnlyExists newTradeInstructionOnlyExists;

	/**
	* @param businessEvent 
	* @return is_event 
	*/
	@Override
	public Boolean evaluate(BusinessEvent businessEvent) {
		Boolean is_event = doEvaluate(businessEvent);
		
		return is_event;
	}

	protected abstract Boolean doEvaluate(BusinessEvent businessEvent);

	protected abstract Mapper<? extends TradeState> openTradeState(BusinessEvent businessEvent);

	protected abstract Mapper<? extends Instruction> newTradeInstruction(BusinessEvent businessEvent);

	protected abstract Mapper<? extends IdentifiedList> packageRef(BusinessEvent businessEvent);

	public static class Qualify_PairOffDefault extends Qualify_PairOff {
		@Override
		protected Boolean doEvaluate(BusinessEvent businessEvent) {
			Boolean is_event = null;
			return assignOutput(is_event, businessEvent);
		}
		
		protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
			is_event = areEqual(MapperS.of(MapperC.<Instruction>of(newTradeInstruction(businessEvent).getMulti()).resultCount()), MapperS.of(MapperS.of(businessEvent).<Instruction>mapC("getInstruction", eventInstruction -> eventInstruction.getInstruction()).resultCount()), CardinalityOperator.All).and(areEqual(MapperC.<TradeState>of(openTradeState(businessEvent).getMulti()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()), MapperC.<Instruction>of(newTradeInstruction(businessEvent).getMulti()).<ReferenceWithMetaTradeState>map("getBefore", instruction -> instruction.getBefore()).<TradeState>map("getValue", _f->_f.getValue()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()), CardinalityOperator.All)).and(areEqual(MapperS.of(MapperC.<IdentifiedList>of(packageRef(businessEvent).getMulti()).resultCount()), MapperS.of(MapperC.<TradeState>of(openTradeState(businessEvent).getMulti()).resultCount()), CardinalityOperator.All)).and(areEqual(MapperS.of(distinct(MapperC.<IdentifiedList>of(packageRef(businessEvent).getMulti())).resultCount()), MapperS.of(Integer.valueOf(1)), CardinalityOperator.All)).get();
			
			return is_event;
		}
		
		@Override
		protected Mapper<? extends TradeState> openTradeState(BusinessEvent businessEvent) {
			return MapperC.<TradeState>of(filterOpenTradeStates.evaluate(MapperS.of(businessEvent).<TradeState>mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti()));
		}
		
		@Override
		protected Mapper<? extends Instruction> newTradeInstruction(BusinessEvent businessEvent) {
			return MapperS.of(businessEvent).<Instruction>mapC("getInstruction", eventInstruction -> eventInstruction.getInstruction())
				.filterItemNullSafe(item -> (Boolean)MapperS.of(newTradeInstructionOnlyExists.evaluate(item.<PrimitiveInstruction>map("getPrimitiveInstruction", instruction -> instruction.getPrimitiveInstruction()).get())).get());
		}
		
		@Override
		protected Mapper<? extends IdentifiedList> packageRef(BusinessEvent businessEvent) {
			return MapperC.<TradeState>of(openTradeState(businessEvent).getMulti()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<ExecutionDetails>map("getExecutionDetails", trade -> trade.getExecutionDetails()).<IdentifiedList>map("getPackageReference", executionDetails -> executionDetails.getPackageReference());
		}
	}
		
		@Override
		public String getNamePrefix() {
			return "Qualify";
		}
}
