package cdm.base.staticdata.identifier.validation;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.base.staticdata.identifier.Identifier;
import cdm.observable.asset.Price;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class IdentifiedListValidator implements Validator<IdentifiedList> {

	@Override
	public ValidationResult<IdentifiedList> validate(RosettaPath path, IdentifiedList o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("listId", (Identifier) o.getListId() != null ? 1 : 0, 1, 1), 
				checkCardinality("componentId", (List<? extends Identifier>) o.getComponentId() == null ? 0 : ((List<? extends Identifier>) o.getComponentId()).size(), 2, 0), 
				checkCardinality("price", (Price) o.getPrice() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("IdentifiedList", ValidationType.CARDINALITY, "IdentifiedList", path, "", error);
		}
		return success("IdentifiedList", ValidationType.CARDINALITY, "IdentifiedList", path, "");
	}

}
