package cdm.base.staticdata.asset.common.validation;

import cdm.base.staticdata.asset.common.TaxonomyClassification;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class TaxonomyClassificationValidator implements Validator<TaxonomyClassification> {

	@Override
	public ValidationResult<TaxonomyClassification> validate(RosettaPath path, TaxonomyClassification o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("className", (String) o.getClassName() != null ? 1 : 0, 0, 1), 
				checkCardinality("value", (String) o.getValue() != null ? 1 : 0, 1, 1), 
				checkCardinality("description", (String) o.getDescription() != null ? 1 : 0, 0, 1), 
				checkCardinality("ordinal", (Integer) o.getOrdinal() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("TaxonomyClassification", ValidationType.CARDINALITY, "TaxonomyClassification", path, "", error);
		}
		return success("TaxonomyClassification", ValidationType.CARDINALITY, "TaxonomyClassification", path, "");
	}

}
