/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web;

import org.ff4j.FF4j;
import org.ff4j.web.ApiConfig;

public class ApiConfigBuilder {
    private ApiConfig apiConfig;

    public ApiConfigBuilder() {
        this.apiConfig = new ApiConfig();
    }

    public ApiConfigBuilder(FF4j ff4j) {
        this.apiConfig = new ApiConfig(ff4j);
    }

    public ApiConfigBuilder(ApiConfig initConf) {
        this.apiConfig = initConf;
    }

    public ApiConfig build() {
        return this.apiConfig;
    }

    public ApiConfigBuilder documentation(boolean b) {
        this.apiConfig.setDocumentation(b);
        return this;
    }

    public ApiConfigBuilder withDocumentation() {
        return this.documentation(true);
    }

    public ApiConfigBuilder withoutDocumentation() {
        return this.documentation(false);
    }

    public ApiConfigBuilder authenticate(boolean b) {
        this.apiConfig.setAuthenticate(b);
        return this;
    }

    public ApiConfigBuilder withAuthentication() {
        return this.authenticate(true);
    }

    public ApiConfigBuilder withoutAuthentication() {
        return this.authenticate(false);
    }

    public ApiConfigBuilder autorize(boolean b) {
        this.apiConfig.setAutorize(b);
        return this;
    }

    public ApiConfigBuilder withAutorization() {
        return this.autorize(true);
    }

    public ApiConfigBuilder withoutAutorization() {
        return this.autorize(false);
    }

    public ApiConfigBuilder addApiKey(String apiKey) {
        this.apiConfig.createApiKey(apiKey, true, true, null);
        return this;
    }

    public ApiConfigBuilder addUser(String userName, String userPassword) {
        this.apiConfig.createUser(userName, userPassword, true, true, null);
        return this;
    }

    public ApiConfigBuilder host(String host) {
        this.apiConfig.setHost(host);
        return this;
    }

    public ApiConfigBuilder webContext(String context) {
        this.apiConfig.setWebContext(context);
        return this;
    }

    public ApiConfigBuilder port(int port) {
        this.apiConfig.setPort(port);
        return this;
    }
}

