/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store.kv;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.mapper.PropertyMapper;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.store.kv.KeyValueDriver;
import org.ff4j.utils.Util;

public class KeyValuePropertyStore<VALUE>
extends AbstractPropertyStore {
    protected KeyValueDriver<String, VALUE> driver;
    protected PropertyMapper<VALUE> propertyMapper;

    public KeyValuePropertyStore() {
    }

    public KeyValuePropertyStore(KeyValueDriver<String, VALUE> driver) {
        this.driver = driver;
    }

    public KeyValuePropertyStore(KeyValueDriver<String, VALUE> driver, PropertyMapper<VALUE> mapper) {
        this.driver = driver;
        this.propertyMapper = mapper;
    }

    @Override
    public boolean existProperty(String name) {
        Util.assertParamHasLength(name, "Property name");
        return this.getDriver().existKey(this.getDriver().getPropertyKey(name));
    }

    @Override
    public <T> void createProperty(Property<T> property) {
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null nor empty");
        }
        if (this.existProperty(property.getName())) {
            throw new PropertyAlreadyExistException(property.getName());
        }
        this.getDriver().putValue(this.getDriver().getPropertyKey(property.getName()), this.propertyMapper.toStore(property));
        this.getDriver().registerProperty(property.getName());
    }

    @Override
    public Property<?> readProperty(String name) {
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
        return (Property)this.getPropertyMapper().fromStore(this.getDriver().getValue(this.getDriver().getPropertyKey(name)));
    }

    @Override
    public void deleteProperty(String name) {
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
        this.getDriver().deleteKey(this.getDriver().getPropertyKey(name));
        this.getDriver().unregisterProperty(name);
    }

    @Override
    public Map<String, Property<?>> readAllProperties() {
        HashMap mapOfProperties = new HashMap();
        for (String propertyName : this.getDriver().getPropertyList()) {
            Property currP = (Property)this.getPropertyMapper().fromStore(this.getDriver().getValue(this.getDriver().getPropertyKey(propertyName)));
            mapOfProperties.put(currP.getName(), currP);
        }
        return mapOfProperties;
    }

    @Override
    public Set<String> listPropertyNames() {
        return this.getDriver().getPropertyList();
    }

    @Override
    public void clear() {
        for (String uid : this.getDriver().getPropertyList()) {
            this.deleteProperty(uid);
        }
    }

    public KeyValueDriver<String, VALUE> getDriver() {
        if (this.driver == null) {
            throw new IllegalStateException("Cannot access target K/V driver, please initialize");
        }
        return this.driver;
    }

    public void setDriver(KeyValueDriver<String, VALUE> driver) {
        this.driver = driver;
    }

    public PropertyMapper<VALUE> getPropertyMapper() {
        if (this.propertyMapper == null) {
            throw new IllegalStateException("Please initialize property mapper");
        }
        return this.propertyMapper;
    }

    public void setPropertyMapper(PropertyMapper<VALUE> mapper) {
        this.propertyMapper = mapper;
    }
}

