/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.repository;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.EventSeries;
import org.ff4j.audit.MutableHitCount;
import org.ff4j.audit.chart.Serie;
import org.ff4j.audit.chart.TimeSeriesChart;
import org.ff4j.audit.repository.AbstractEventRepository;
import org.ff4j.utils.Util;

public class InMemoryEventRepository
extends AbstractEventRepository {
    private static final int DEFAULT_QUEUE_CAPACITY = 100000;
    private int queueCapacity = 100000;
    private Map<String, Map<String, EventSeries>> featureUsageEvents = new ConcurrentHashMap<String, Map<String, EventSeries>>();
    private Map<String, Map<String, EventSeries>> checkOffEvents = new ConcurrentHashMap<String, Map<String, EventSeries>>();
    private Map<String, EventSeries> auditTrailEvents = new ConcurrentHashMap<String, EventSeries>();

    public InMemoryEventRepository() {
        this(100000);
    }

    public InMemoryEventRepository(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    @Override
    public void createSchema() {
    }

    @Override
    public boolean saveEvent(Event e) {
        Util.assertEvent(e);
        if ("checkOn".equalsIgnoreCase(e.getAction())) {
            return this.saveEvent(e, this.featureUsageEvents);
        }
        if ("checkOff".equalsIgnoreCase(e.getAction())) {
            return this.saveEvent(e, this.checkOffEvents);
        }
        String key = this.getKeyDate(e.getTimestamp());
        if (!this.auditTrailEvents.containsKey(key)) {
            this.auditTrailEvents.put(key, new EventSeries(this.queueCapacity));
        }
        return this.auditTrailEvents.get(key).add(e);
    }

    @Override
    public Map<String, MutableHitCount> getFeatureUsageHitCount(EventQueryDefinition query) {
        TreeMap<String, MutableHitCount> hitRatio = new TreeMap<String, MutableHitCount>();
        for (Event event : this.searchFeatureUsageEvents(query)) {
            if (!hitRatio.containsKey(event.getName())) {
                hitRatio.put(event.getName(), new MutableHitCount());
            }
            ((MutableHitCount)hitRatio.get(event.getName())).inc();
        }
        return hitRatio;
    }

    @Override
    public Map<String, MutableHitCount> getSourceHitCount(EventQueryDefinition query) {
        TreeMap<String, MutableHitCount> hitRatio = new TreeMap<String, MutableHitCount>();
        for (Event event : this.searchFeatureUsageEvents(query)) {
            if (!hitRatio.containsKey(event.getSource())) {
                hitRatio.put(event.getSource(), new MutableHitCount());
            }
            ((MutableHitCount)hitRatio.get(event.getSource())).inc();
        }
        return hitRatio;
    }

    @Override
    public Map<String, MutableHitCount> getHostHitCount(EventQueryDefinition query) {
        TreeMap<String, MutableHitCount> hitRatio = new TreeMap<String, MutableHitCount>();
        for (Event event : this.searchFeatureUsageEvents(query)) {
            if (!hitRatio.containsKey(event.getHostName())) {
                hitRatio.put(event.getHostName(), new MutableHitCount());
            }
            ((MutableHitCount)hitRatio.get(event.getHostName())).inc();
        }
        return hitRatio;
    }

    @Override
    public Map<String, MutableHitCount> getUserHitCount(EventQueryDefinition query) {
        TreeMap<String, MutableHitCount> hitRatio = new TreeMap<String, MutableHitCount>();
        for (Event event : this.searchFeatureUsageEvents(query)) {
            String user;
            String string = user = Util.hasLength(event.getUser()) ? event.getUser() : "anonymous";
            if (!hitRatio.containsKey(user)) {
                hitRatio.put(user, new MutableHitCount());
            }
            ((MutableHitCount)hitRatio.get(user)).inc();
        }
        return hitRatio;
    }

    private boolean saveEvent(Event e, Map<String, Map<String, EventSeries>> target) {
        String key = this.getKeyDate(e.getTimestamp());
        String uid = e.getName();
        if (!target.containsKey(key)) {
            target.put(key, new ConcurrentHashMap());
        }
        if (!target.get(key).containsKey(uid)) {
            target.get(key).put(uid, new EventSeries(this.queueCapacity));
        }
        return target.get(key).get(uid).add(e);
    }

    @Override
    public TimeSeriesChart getFeatureUsageHistory(EventQueryDefinition query, TimeUnit units) {
        TimeSeriesChart tsc = new TimeSeriesChart(query.getFrom(), query.getTo(), units);
        for (String currentDay : this.getCandidateDays(query.getFrom(), query.getTo())) {
            if (!this.featureUsageEvents.containsKey(currentDay)) continue;
            for (Map.Entry<String, Serializable> entry : this.featureUsageEvents.get(currentDay).entrySet()) {
                String currentFeatureName = entry.getKey();
                Set<String> filteredFeatures = query.getNamesFilter();
                if (filteredFeatures != null && !filteredFeatures.isEmpty() && !filteredFeatures.contains(currentFeatureName)) continue;
                for (Event evt : (EventSeries)entry.getValue()) {
                    if (!this.isEventInInterval(evt, query.getFrom(), query.getTo())) continue;
                    if (!tsc.getSeries().containsKey(currentFeatureName)) {
                        tsc.createNewSerie(currentFeatureName);
                    }
                    Serie<Map<String, MutableHitCount>> serie = tsc.getSeries().get(currentFeatureName);
                    String slotName = tsc.getSdf().format(new Date(evt.getTimestamp()));
                    if (!serie.getValue().containsKey(slotName)) continue;
                    serie.getValue().get(slotName).inc();
                }
            }
        }
        List<String> colors = Util.generateHSVGradient("ee1100", "442299", tsc.getSeries().size());
        int idxColor = 0;
        for (Map.Entry<String, Serializable> entry : tsc.getSeries().entrySet()) {
            ((Serie)entry.getValue()).setColor(colors.get(idxColor));
            ++idxColor;
        }
        return tsc;
    }

    @Override
    public EventSeries getAuditTrail(EventQueryDefinition q) {
        EventSeries resultSeries = new EventSeries(10000L);
        for (String currentDay : this.getCandidateDays(q.getFrom(), q.getTo())) {
            if (!this.auditTrailEvents.containsKey(currentDay)) continue;
            for (Event evt : this.auditTrailEvents.get(currentDay)) {
                if (!q.match(evt)) continue;
                resultSeries.add(evt);
            }
        }
        return resultSeries;
    }

    @Override
    public void purgeAuditTrail(EventQueryDefinition q) {
        for (String currentDay : this.getCandidateDays(q.getFrom(), q.getTo())) {
            if (!this.auditTrailEvents.containsKey(currentDay)) continue;
            for (Event evt : this.auditTrailEvents.get(currentDay)) {
                if (!q.match(evt)) continue;
                this.auditTrailEvents.get(currentDay).remove(evt);
            }
            if (!this.auditTrailEvents.get(currentDay).isEmpty()) continue;
            this.auditTrailEvents.remove(currentDay);
        }
    }

    @Override
    public void purgeFeatureUsage(EventQueryDefinition q) {
        Set<String> candidateDates = this.getCandidateDays(q.getFrom(), q.getTo());
        for (String currentDay : candidateDates) {
            if (!this.featureUsageEvents.containsKey(currentDay)) continue;
            Map<String, EventSeries> currentDayEvents = this.featureUsageEvents.get(currentDay);
            for (String currentFeature : currentDayEvents.keySet()) {
                for (Event evt : currentDayEvents.get(currentFeature)) {
                    if (q.match(evt)) {
                        this.removeEventIfPresent(currentDayEvents.get(currentFeature), evt);
                    }
                    if (!currentDayEvents.get(currentFeature).isEmpty()) continue;
                    currentDayEvents.remove(currentFeature);
                }
            }
            if (!currentDayEvents.isEmpty()) continue;
            this.featureUsageEvents.remove(currentDay);
        }
    }

    private void removeEventIfPresent(EventSeries es, Event evt) {
        for (Event currentEvent : es) {
            if (!currentEvent.getUuid().equalsIgnoreCase(evt.getUuid())) continue;
            es.remove(currentEvent);
        }
    }

    @Override
    public EventSeries searchFeatureUsageEvents(EventQueryDefinition query) {
        EventSeries es = new EventSeries(1000000L);
        for (String currentDay : this.getCandidateDays(query.getFrom(), query.getTo())) {
            if (!this.featureUsageEvents.containsKey(currentDay)) continue;
            Map<String, EventSeries> currentDayEvents = this.featureUsageEvents.get(currentDay);
            for (String currentFeature : currentDayEvents.keySet()) {
                if (!query.matchName(currentFeature)) continue;
                for (Event evt : currentDayEvents.get(currentFeature)) {
                    if (!query.match(evt)) continue;
                    es.add(evt);
                }
            }
        }
        return es;
    }

    @Override
    public Event getEventByUUID(String uuid, Long timestamp) {
        Event evt;
        if (timestamp != null) {
            String targetDate = KDF.format(new Date(timestamp));
            return this.searchEventById(uuid, targetDate);
        }
        HashSet<String> searchedDate = new HashSet<String>();
        for (String currentDate : this.auditTrailEvents.keySet()) {
            if (!searchedDate.contains(currentDate) && (evt = this.searchEventById(uuid, currentDate)) != null) {
                return evt;
            }
            searchedDate.add(currentDate);
        }
        for (String currentDate : this.featureUsageEvents.keySet()) {
            if (!searchedDate.contains(currentDate) && (evt = this.searchEventById(uuid, currentDate)) != null) {
                return evt;
            }
            searchedDate.add(currentDate);
        }
        for (String currentDate : this.checkOffEvents.keySet()) {
            if (!searchedDate.contains(currentDate) && (evt = this.searchEventById(uuid, currentDate)) != null) {
                return evt;
            }
            searchedDate.add(currentDate);
        }
        return null;
    }

    private Event searchEventById(String uuid, String targetDate) {
        Map<String, EventSeries> maOfChecKoff;
        Util.assertNotNull(targetDate, uuid);
        Event evt = this.getFromEventSeries(this.auditTrailEvents.get(targetDate), uuid);
        if (evt != null) {
            return evt;
        }
        Map<String, EventSeries> maOfFeaturesIsages = this.featureUsageEvents.get(targetDate);
        if (maOfFeaturesIsages != null) {
            for (EventSeries es : maOfFeaturesIsages.values()) {
                evt = this.getFromEventSeries(es, uuid);
                if (evt == null) continue;
                return evt;
            }
        }
        if ((maOfChecKoff = this.checkOffEvents.get(targetDate)) != null) {
            for (EventSeries es : maOfChecKoff.values()) {
                evt = this.getFromEventSeries(es, uuid);
                if (evt == null) continue;
                return evt;
            }
        }
        return evt;
    }

    private Event getFromEventSeries(EventSeries es, String uuid) {
        if (es == null) {
            return null;
        }
        for (Event evt : es) {
            if (!evt.getUuid().equalsIgnoreCase(uuid)) continue;
            return evt;
        }
        return null;
    }
}

