/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit;

import org.ff4j.FF4j;
import org.ff4j.audit.Event;

public class EventBuilder {
    private Event event = new Event();

    public EventBuilder() {
    }

    public EventBuilder(FF4j ff4j) {
        this();
        this.event.setSource(ff4j.getSource());
        if (ff4j.getAuthorizationsManager() != null) {
            this.event.setUser(ff4j.getAuthorizationsManager().getCurrentUserName());
        }
    }

    public EventBuilder feature(String uid) {
        this.event.setType("feature");
        this.event.setName(uid);
        return this;
    }

    public EventBuilder group(String groupName) {
        this.event.setType("group");
        this.event.setName(groupName);
        return this;
    }

    public EventBuilder property(String name) {
        this.event.setType("property");
        this.event.setName(name);
        return this;
    }

    public EventBuilder action(String action) {
        this.event.setAction(action);
        return this;
    }

    public EventBuilder duration(long duration) {
        this.event.setDuration(duration);
        return this;
    }

    public EventBuilder type(String type) {
        this.event.setType(type);
        return this;
    }

    public EventBuilder value(String val) {
        this.event.setValue(val);
        return this;
    }

    public EventBuilder name(String name) {
        this.event.setName(name);
        return this;
    }

    public Event build() {
        return this.event;
    }
}

