/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.ff4j.utils.IOUtil;

public class Event
implements Serializable,
Comparable<Event> {
    private static final long serialVersionUID = 6490780530212257217L;
    private String uuid;
    private long timestamp;
    private long duration = 0L;
    private String hostName;
    private String source;
    private String user;
    private String name;
    private String type;
    private String action;
    private String value;
    private Map<String, String> customKeys = new HashMap<String, String>();

    public Event() {
        this.uuid = UUID.randomUUID().toString();
        this.timestamp = System.currentTimeMillis();
        this.hostName = IOUtil.resolveHostName();
    }

    public Event(String pSource, String pType, String pName, String pAction) {
        this();
        this.source = pSource;
        this.type = pType;
        this.name = pName;
        this.action = pAction;
    }

    public String toString() {
        return this.toJson();
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"id\": \"" + this.uuid + "\"");
        sb.append(", \"timestamp\":" + this.timestamp);
        this.keyAsString(sb, "hostName", this.hostName);
        this.keyAsString(sb, "source", this.source);
        this.keyAsString(sb, "user", this.user);
        this.keyAsString(sb, "name", this.name);
        this.keyAsString(sb, "type", this.type);
        this.keyAsString(sb, "action", this.action);
        this.keyAsString(sb, "value", this.value);
        sb.append(", \"duration\":" + this.duration);
        if (this.customKeys != null && !this.customKeys.isEmpty()) {
            for (Map.Entry<String, String> customKeysEntry : this.customKeys.entrySet()) {
                if (null == customKeysEntry.getValue()) continue;
                this.keyAsString(sb, customKeysEntry.getKey(), customKeysEntry.getValue());
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public void put(String key, String value) {
        this.getCustomKeys().put(key, value);
    }

    public String getKey(String key) {
        return this.getCustomKeys().get(key);
    }

    private void keyAsString(StringBuilder sb, String name, String value) {
        if (value != null) {
            sb.append(", \"" + name + "\": \"" + value + "\"");
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Date getDate() {
        return new Date(this.getTimestamp());
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Map<String, String> getCustomKeys() {
        return this.customKeys;
    }

    public void setCustomKeys(Map<String, String> customKeys) {
        this.customKeys = customKeys;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public int compareTo(Event evt) {
        int myTime = new Long(this.getTimestamp() - evt.getTimestamp()).intValue();
        return myTime != 0 ? myTime : evt.getUuid().compareTo(this.getUuid());
    }
}

