/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.utils;

import java.util.Map;
import java.util.Set;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.property.AbstractProperty;

public class JsonUtils {
    private JsonUtils() {
    }

    public static final String permissionsAsJson(Set<String> permissions) {
        StringBuilder json = new StringBuilder();
        if (null != permissions) {
            json.append("[");
            if (!permissions.isEmpty()) {
                boolean first = true;
                for (String auth : permissions) {
                    json.append(first ? "" : ",");
                    json.append("\"" + auth + "\"");
                    first = false;
                }
            }
            json.append("]");
        } else {
            json.append("null");
        }
        return json.toString();
    }

    public static final String flippingStrategyAsJson(FlippingStrategy flippingStrategy) {
        StringBuilder json = new StringBuilder();
        if (null != flippingStrategy) {
            json.append("{\"initParams\":{");
            Map<String, String> iparams = flippingStrategy.getInitParams();
            if (iparams != null && !iparams.isEmpty()) {
                boolean first = true;
                for (Map.Entry<String, String> param : iparams.entrySet()) {
                    json.append(first ? "" : ",");
                    json.append("\"" + param.getKey() + "\":\"" + param.getValue() + "\"");
                    first = false;
                }
            }
            json.append("},\"type\":\"");
            json.append(flippingStrategy.getClass().getCanonicalName());
            json.append("\"}");
        } else {
            json.append("null");
        }
        return json.toString();
    }

    public static final String customPropertiesAsJson(Map<String, ? extends AbstractProperty<?>> customProperties) {
        StringBuilder json = new StringBuilder("{");
        if (null != customProperties && !customProperties.isEmpty()) {
            boolean first = true;
            for (String key : customProperties.keySet()) {
                json.append(first ? "" : ",");
                json.append("\"" + key + "\":" + customProperties.get(key).toString());
                first = false;
            }
        }
        json.append("}");
        return json.toString();
    }
}

