/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.strategy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.core.FeatureStore;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.strategy.AbstractFlipStrategy;

public class ClientFilterStrategy
extends AbstractFlipStrategy {
    private static final String PARAM_CLIENTLIST = "grantedClients";
    public static final String CLIENT_HOSTNAME = "clientHostName";
    private static final String SPLITTER = ",";
    private final Set<String> setOfGrantedClient = new HashSet<String>();
    private String rawClientList = null;

    public ClientFilterStrategy() {
    }

    public ClientFilterStrategy(String clientList) {
        this.rawClientList = clientList;
        this.getInitParams().put(PARAM_CLIENTLIST, clientList);
        for (String client : this.rawClientList.split(SPLITTER)) {
            this.setOfGrantedClient.add(client.trim());
        }
    }

    @Override
    public void init(String featureName, Map<String, String> initParams) {
        super.init(featureName, initParams);
        if (initParams != null && initParams.containsKey(PARAM_CLIENTLIST)) {
            this.rawClientList = initParams.get(PARAM_CLIENTLIST);
        }
        this.setOfGrantedClient.addAll(Arrays.asList(this.rawClientList.split(SPLITTER)));
    }

    @Override
    public boolean evaluate(String featureName, FeatureStore store, FlippingExecutionContext executionContext) {
        if (null == executionContext || !executionContext.containsKey(CLIENT_HOSTNAME)) {
            throw new IllegalArgumentException("To work with " + this.getClass().getCanonicalName() + " you must provide '" + CLIENT_HOSTNAME + "' parameter in execution context");
        }
        return this.setOfGrantedClient.contains(executionContext.getString(CLIENT_HOSTNAME));
    }
}

