/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.spi;

import com.jsoniter.spi.Config;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.Extension;
import com.jsoniter.spi.TypeLiteral;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsoniterSpi {
    private static Config defaultConfig;
    private static List<Extension> extensions;
    private static Map<Class, Class> typeImpls;
    private static Map<Type, Decoder> globalMapKeyDecoders;
    private static Map<Type, Encoder> globalMapKeyEncoders;
    private static Map<Type, Decoder> globalTypeDecoders;
    private static Map<Type, Encoder> globalTypeEncoders;
    private static Map<TypeProperty, Decoder> globalPropertyDecoders;
    private static Map<TypeProperty, Encoder> globalPropertyEncoders;
    private static ThreadLocal<Config> currentConfig;
    private static volatile Map<Object, String> configNames;
    private static volatile Map<String, Encoder> mapKeyEncoders;
    private static volatile Map<String, Decoder> mapKeyDecoders;
    private static volatile Map<String, Encoder> encoders;
    private static volatile Map<String, Decoder> decoders;
    private static volatile Map<Class, Extension> objectFactories;

    public static void setCurrentConfig(Config val) {
        currentConfig.set(val);
    }

    public static void clearCurrentConfig() {
        currentConfig.set(defaultConfig);
    }

    public static Config getCurrentConfig() {
        return currentConfig.get();
    }

    public static void setDefaultConfig(Config val) {
        defaultConfig = val;
    }

    public static Config getDefaultConfig() {
        return defaultConfig;
    }

    public static String assignConfigName(Object obj) {
        String configName = configNames.get(obj);
        if (configName != null) {
            return configName;
        }
        return JsoniterSpi.assignNewConfigName(obj);
    }

    private static synchronized String assignNewConfigName(Object obj) {
        String configName = configNames.get(obj);
        if (configName != null) {
            return configName;
        }
        long hash = obj.toString().hashCode();
        if (hash < 0L) {
            hash = Long.MAX_VALUE + hash;
        }
        configName = "jsoniter_codegen.cfg" + hash + ".";
        JsoniterSpi.copyGlobalSettings(configName);
        HashMap<Object, String> newCache = new HashMap<Object, String>(configNames);
        newCache.put(obj, configName);
        configNames = newCache;
        return configName;
    }

    public static void registerExtension(Extension extension) {
        if (!extensions.contains(extension)) {
            extensions.add(extension);
        }
    }

    public static List<Extension> getExtensions() {
        ArrayList<Extension> combined = new ArrayList<Extension>(extensions);
        combined.add(currentConfig.get());
        return combined;
    }

    public static void registerMapKeyDecoder(Type mapKeyType, Decoder mapKeyDecoder) {
        globalMapKeyDecoders.put(mapKeyType, mapKeyDecoder);
        JsoniterSpi.copyGlobalMapKeyDecoder(JsoniterSpi.getCurrentConfig().configName(), mapKeyType, mapKeyDecoder);
    }

    public static void registerMapKeyEncoder(Type mapKeyType, Encoder mapKeyEncoder) {
        globalMapKeyEncoders.put(mapKeyType, mapKeyEncoder);
        JsoniterSpi.copyGlobalMapKeyEncoder(JsoniterSpi.getCurrentConfig().configName(), mapKeyType, mapKeyEncoder);
    }

    public static void registerTypeImplementation(Class superClazz, Class implClazz) {
        typeImpls.put(superClazz, implClazz);
    }

    public static Class getTypeImplementation(Class superClazz) {
        return typeImpls.get(superClazz);
    }

    public static void registerTypeDecoder(Class clazz, Decoder decoder) {
        globalTypeDecoders.put(clazz, decoder);
        JsoniterSpi.copyGlobalTypeDecoder(JsoniterSpi.getCurrentConfig().configName(), clazz, decoder);
    }

    public static void registerTypeDecoder(TypeLiteral typeLiteral, Decoder decoder) {
        globalTypeDecoders.put(typeLiteral.getType(), decoder);
        JsoniterSpi.copyGlobalTypeDecoder(JsoniterSpi.getCurrentConfig().configName(), typeLiteral.getType(), decoder);
    }

    public static void registerTypeEncoder(Class clazz, Encoder encoder) {
        globalTypeEncoders.put(clazz, encoder);
        JsoniterSpi.copyGlobalTypeEncoder(JsoniterSpi.getCurrentConfig().configName(), clazz, encoder);
    }

    public static void registerTypeEncoder(TypeLiteral typeLiteral, Encoder encoder) {
        globalTypeEncoders.put(typeLiteral.getType(), encoder);
        JsoniterSpi.copyGlobalTypeEncoder(JsoniterSpi.getCurrentConfig().configName(), typeLiteral.getType(), encoder);
    }

    public static void registerPropertyDecoder(Class clazz, String property, Decoder decoder) {
        globalPropertyDecoders.put(new TypeProperty(clazz, property), decoder);
        JsoniterSpi.copyGlobalPropertyDecoder(JsoniterSpi.getCurrentConfig().configName(), clazz, property, decoder);
    }

    public static void registerPropertyDecoder(TypeLiteral typeLiteral, String property, Decoder decoder) {
        globalPropertyDecoders.put(new TypeProperty(typeLiteral.getType(), property), decoder);
        JsoniterSpi.copyGlobalPropertyDecoder(JsoniterSpi.getCurrentConfig().configName(), typeLiteral.getType(), property, decoder);
    }

    public static void registerPropertyEncoder(Class clazz, String property, Encoder encoder) {
        globalPropertyEncoders.put(new TypeProperty(clazz, property), encoder);
        JsoniterSpi.copyGlobalPropertyEncoder(JsoniterSpi.getCurrentConfig().configName(), clazz, property, encoder);
    }

    public static void registerPropertyEncoder(TypeLiteral typeLiteral, String property, Encoder encoder) {
        globalPropertyEncoders.put(new TypeProperty(typeLiteral.getType(), property), encoder);
        JsoniterSpi.copyGlobalPropertyEncoder(JsoniterSpi.getCurrentConfig().configName(), typeLiteral.getType(), property, encoder);
    }

    private static void copyGlobalSettings(String configName) {
        for (Map.Entry<Type, Decoder> entry : globalMapKeyDecoders.entrySet()) {
            JsoniterSpi.copyGlobalMapKeyDecoder(configName, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Type, Object> entry : globalMapKeyEncoders.entrySet()) {
            JsoniterSpi.copyGlobalMapKeyEncoder(configName, entry.getKey(), (Encoder)entry.getValue());
        }
        for (Map.Entry<Type, Object> entry : globalTypeDecoders.entrySet()) {
            JsoniterSpi.copyGlobalTypeDecoder(configName, entry.getKey(), (Decoder)entry.getValue());
        }
        for (Map.Entry<Type, Object> entry : globalTypeEncoders.entrySet()) {
            JsoniterSpi.copyGlobalTypeEncoder(configName, entry.getKey(), (Encoder)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : globalPropertyDecoders.entrySet()) {
            JsoniterSpi.copyGlobalPropertyDecoder(configName, ((TypeProperty)entry.getKey()).type, ((TypeProperty)entry.getKey()).property, (Decoder)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : globalPropertyEncoders.entrySet()) {
            JsoniterSpi.copyGlobalPropertyEncoder(configName, ((TypeProperty)entry.getKey()).type, ((TypeProperty)entry.getKey()).property, (Encoder)entry.getValue());
        }
    }

    private static void copyGlobalPropertyEncoder(String configName, Type type, String property, Encoder propertyEncoder) {
        JsoniterSpi.addNewEncoder(property + "@" + TypeLiteral.create(type).getEncoderCacheKey(), propertyEncoder);
    }

    private static void copyGlobalPropertyDecoder(String configName, Type type, String property, Decoder propertyDecoder) {
        JsoniterSpi.addNewDecoder(property + "@" + TypeLiteral.create(type).getDecoderCacheKey(), propertyDecoder);
    }

    private static void copyGlobalTypeEncoder(String configName, Type type, Encoder typeEncoder) {
        JsoniterSpi.addNewEncoder(TypeLiteral.create(type).getEncoderCacheKey(configName), typeEncoder);
    }

    private static void copyGlobalTypeDecoder(String configName, Type type, Decoder typeDecoder) {
        JsoniterSpi.addNewDecoder(TypeLiteral.create(type).getDecoderCacheKey(configName), typeDecoder);
    }

    private static void copyGlobalMapKeyDecoder(String configName, Type mapKeyType, Decoder mapKeyDecoder) {
        JsoniterSpi.addNewMapDecoder(TypeLiteral.create(mapKeyType).getDecoderCacheKey(configName), mapKeyDecoder);
    }

    private static void copyGlobalMapKeyEncoder(String configName, Type mapKeyType, Encoder mapKeyEncoder) {
        JsoniterSpi.addNewMapEncoder(TypeLiteral.create(mapKeyType).getEncoderCacheKey(configName), mapKeyEncoder);
    }

    public static String getMapKeyEncoderCacheKey(Type mapKeyType) {
        TypeLiteral typeLiteral = TypeLiteral.create(mapKeyType);
        return typeLiteral.getEncoderCacheKey();
    }

    public static String getMapKeyDecoderCacheKey(Type mapKeyType) {
        TypeLiteral typeLiteral = TypeLiteral.create(mapKeyType);
        return typeLiteral.getDecoderCacheKey();
    }

    public static synchronized void addNewMapDecoder(String cacheKey, Decoder mapKeyDecoder) {
        HashMap<String, Decoder> newCache = new HashMap<String, Decoder>(mapKeyDecoders);
        newCache.put(cacheKey, mapKeyDecoder);
        mapKeyDecoders = newCache;
    }

    public static Decoder getMapKeyDecoder(String cacheKey) {
        return mapKeyDecoders.get(cacheKey);
    }

    public static synchronized void addNewMapEncoder(String cacheKey, Encoder mapKeyEncoder) {
        HashMap<String, Encoder> newCache = new HashMap<String, Encoder>(mapKeyEncoders);
        newCache.put(cacheKey, mapKeyEncoder);
        mapKeyEncoders = newCache;
    }

    public static Encoder getMapKeyEncoder(String cacheKey) {
        return mapKeyEncoders.get(cacheKey);
    }

    public static Decoder getDecoder(String cacheKey) {
        return decoders.get(cacheKey);
    }

    public static synchronized void addNewDecoder(String cacheKey, Decoder decoder) {
        HashMap<String, Decoder> newCache = new HashMap<String, Decoder>(decoders);
        if (decoder == null) {
            newCache.remove(cacheKey);
        } else {
            newCache.put(cacheKey, decoder);
        }
        decoders = newCache;
    }

    public static Encoder getEncoder(String cacheKey) {
        return encoders.get(cacheKey);
    }

    public static synchronized void addNewEncoder(String cacheKey, Encoder encoder) {
        HashMap<String, Encoder> newCache = new HashMap<String, Encoder>(encoders);
        if (encoder == null) {
            newCache.remove(cacheKey);
        } else {
            newCache.put(cacheKey, encoder);
        }
        encoders = newCache;
    }

    public static boolean canCreate(Class clazz) {
        if (objectFactories.containsKey(clazz)) {
            return true;
        }
        for (Extension extension : JsoniterSpi.getExtensions()) {
            if (!extension.canCreate(clazz)) continue;
            JsoniterSpi.addObjectFactory(clazz, extension);
            return true;
        }
        return false;
    }

    public static Object create(Class clazz) {
        return JsoniterSpi.getObjectFactory(clazz).create(clazz);
    }

    public static Extension getObjectFactory(Class clazz) {
        return objectFactories.get(clazz);
    }

    private static synchronized void addObjectFactory(Class clazz, Extension extension) {
        HashMap<Class, Extension> copy = new HashMap<Class, Extension>(objectFactories);
        copy.put(clazz, extension);
        objectFactories = copy;
    }

    static {
        extensions = new ArrayList<Extension>();
        typeImpls = new HashMap<Class, Class>();
        globalMapKeyDecoders = new HashMap<Type, Decoder>();
        globalMapKeyEncoders = new HashMap<Type, Encoder>();
        globalTypeDecoders = new HashMap<Type, Decoder>();
        globalTypeEncoders = new HashMap<Type, Encoder>();
        globalPropertyDecoders = new HashMap<TypeProperty, Decoder>();
        globalPropertyEncoders = new HashMap<TypeProperty, Encoder>();
        currentConfig = new ThreadLocal<Config>(){

            @Override
            protected Config initialValue() {
                return defaultConfig;
            }
        };
        configNames = new HashMap<Object, String>();
        mapKeyEncoders = new HashMap<String, Encoder>();
        mapKeyDecoders = new HashMap<String, Decoder>();
        encoders = new HashMap<String, Encoder>();
        decoders = new HashMap<String, Decoder>();
        objectFactories = new HashMap<Class, Extension>();
        defaultConfig = Config.INSTANCE;
    }

    private static class TypeProperty {
        public final Type type;
        public final String property;

        private TypeProperty(Type type, String property) {
            this.type = type;
            this.property = property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeProperty that = (TypeProperty)o;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
                return false;
            }
            return this.property != null ? this.property.equals(that.property) : that.property == null;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.property != null ? this.property.hashCode() : 0);
            return result;
        }
    }
}

