/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.JsonIterator;
import com.jsoniter.JsonIteratorPool;
import com.jsoniter.ValueType;
import com.jsoniter.any.LazyAny;
import com.jsoniter.spi.JsonException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

class DoubleLazyAny
extends LazyAny {
    private boolean isCached;
    private double cache;

    public DoubleLazyAny(byte[] data, int head, int tail) {
        super(data, head, tail);
    }

    @Override
    public ValueType valueType() {
        return ValueType.NUMBER;
    }

    @Override
    public Object object() {
        this.fillCache();
        return this.cache;
    }

    @Override
    public boolean toBoolean() {
        this.fillCache();
        return this.cache != 0.0;
    }

    @Override
    public int toInt() {
        this.fillCache();
        return (int)this.cache;
    }

    @Override
    public long toLong() {
        this.fillCache();
        return (long)this.cache;
    }

    @Override
    public float toFloat() {
        this.fillCache();
        return (float)this.cache;
    }

    @Override
    public double toDouble() {
        this.fillCache();
        return this.cache;
    }

    @Override
    public BigInteger toBigInteger() {
        return new BigInteger(this.toString());
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.toString());
    }

    private void fillCache() {
        if (!this.isCached) {
            JsonIterator iter = this.parse();
            try {
                this.cache = iter.readDouble();
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
            finally {
                JsonIteratorPool.returnJsonIterator(iter);
            }
            this.isCached = true;
        }
    }
}

