/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.CodegenImplNative;
import com.jsoniter.CodegenImplObjectHash;
import com.jsoniter.spi.Binding;
import com.jsoniter.spi.ClassDescriptor;
import com.jsoniter.spi.ConstructorDescriptor;
import com.jsoniter.spi.GenericsHelper;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.WrapperDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CodegenImplObjectStrict {
    static final Map<String, String> DEFAULT_VALUES = new HashMap<String, String>(){
        {
            this.put("float", "0.0f");
            this.put("double", "0.0d");
            this.put("boolean", "false");
            this.put("byte", "0");
            this.put("short", "0");
            this.put("int", "0");
            this.put("char", "0");
            this.put("long", "0");
        }
    };

    CodegenImplObjectStrict() {
    }

    public static String genObjectUsingStrict(ClassDescriptor desc) {
        List<Binding> allBindings = desc.allDecoderBindings();
        int lastRequiredIdx = CodegenImplObjectStrict.assignMaskForRequiredProperties(allBindings);
        boolean hasRequiredBinding = lastRequiredIdx > 0;
        long expectedTracker = Long.MAX_VALUE >> 63 - lastRequiredIdx;
        Map<Integer, Object> trieTree = CodegenImplObjectStrict.buildTriTree(allBindings);
        StringBuilder lines = new StringBuilder();
        CodegenImplObjectStrict.append(lines, "java.lang.Object existingObj = com.jsoniter.CodegenAccess.resetExistingObject(iter);");
        CodegenImplObjectStrict.append(lines, "if (iter.readNull()) { return null; }");
        if (hasRequiredBinding) {
            CodegenImplObjectStrict.append(lines, "long tracker = 0;");
        }
        if (desc.ctor.parameters.isEmpty()) {
            CodegenImplObjectStrict.append(lines, "{{clazz}} obj = {{newInst}};");
            CodegenImplObjectStrict.append(lines, "if (!com.jsoniter.CodegenAccess.readObjectStart(iter)) {");
            if (hasRequiredBinding) {
                CodegenImplObjectStrict.appendMissingRequiredProperties(lines, desc);
            }
            CodegenImplObjectStrict.append(lines, "return obj;");
            CodegenImplObjectStrict.append(lines, "}");
        } else {
            for (Binding parameter : desc.ctor.parameters) {
                CodegenImplObjectHash.appendVarDef(lines, parameter);
            }
            CodegenImplObjectStrict.append(lines, "if (!com.jsoniter.CodegenAccess.readObjectStart(iter)) {");
            if (hasRequiredBinding) {
                CodegenImplObjectStrict.appendMissingRequiredProperties(lines, desc);
            } else {
                CodegenImplObjectStrict.append(lines, "return {{newInst}};");
            }
            CodegenImplObjectStrict.append(lines, "}");
            for (Binding field : desc.fields) {
                if (field.fromNames.length == 0) continue;
                CodegenImplObjectHash.appendVarDef(lines, field);
            }
            for (Binding setter : desc.setters) {
                CodegenImplObjectHash.appendVarDef(lines, setter);
            }
        }
        for (WrapperDescriptor wrapper : desc.bindingTypeWrappers) {
            for (Binding param : wrapper.parameters) {
                CodegenImplObjectHash.appendVarDef(lines, param);
            }
        }
        if (desc.onExtraProperties != null || !desc.keyValueTypeWrappers.isEmpty()) {
            CodegenImplObjectStrict.append(lines, "java.util.Map extra = null;");
        }
        CodegenImplObjectStrict.append(lines, "com.jsoniter.spi.Slice field = com.jsoniter.CodegenAccess.readObjectFieldAsSlice(iter);");
        CodegenImplObjectStrict.append(lines, "boolean once = true;");
        CodegenImplObjectStrict.append(lines, "while (once) {");
        CodegenImplObjectStrict.append(lines, "once = false;");
        String rendered = CodegenImplObjectStrict.renderTriTree(trieTree);
        if (desc.ctor.parameters.isEmpty()) {
            for (Binding field : desc.fields) {
                if (field.fromNames.length == 0) continue;
                rendered = CodegenImplObjectStrict.updateBindingSetOp(rendered, field);
            }
            for (Binding setter : desc.setters) {
                rendered = CodegenImplObjectStrict.updateBindingSetOp(rendered, setter);
            }
        }
        if (CodegenImplObjectStrict.hasAnythingToBindFrom(allBindings)) {
            CodegenImplObjectStrict.append(lines, "switch (field.len()) {");
            CodegenImplObjectStrict.append(lines, rendered);
            CodegenImplObjectStrict.append(lines, "}");
        }
        CodegenImplObjectStrict.appendOnUnknownField(lines, desc);
        CodegenImplObjectStrict.append(lines, "}");
        CodegenImplObjectStrict.append(lines, "while (com.jsoniter.CodegenAccess.nextToken(iter) == ',') {");
        CodegenImplObjectStrict.append(lines, "field = com.jsoniter.CodegenAccess.readObjectFieldAsSlice(iter);");
        if (CodegenImplObjectStrict.hasAnythingToBindFrom(allBindings)) {
            CodegenImplObjectStrict.append(lines, "switch (field.len()) {");
            CodegenImplObjectStrict.append(lines, rendered);
            CodegenImplObjectStrict.append(lines, "}");
        }
        CodegenImplObjectStrict.appendOnUnknownField(lines, desc);
        CodegenImplObjectStrict.append(lines, "}");
        if (hasRequiredBinding) {
            CodegenImplObjectStrict.append(lines, "if (tracker != " + expectedTracker + "L) {");
            CodegenImplObjectStrict.appendMissingRequiredProperties(lines, desc);
            CodegenImplObjectStrict.append(lines, "}");
        }
        if (desc.onExtraProperties != null) {
            CodegenImplObjectStrict.appendSetExtraProperteis(lines, desc);
        }
        if (!desc.keyValueTypeWrappers.isEmpty()) {
            CodegenImplObjectStrict.appendSetExtraToKeyValueTypeWrappers(lines, desc);
        }
        if (!desc.ctor.parameters.isEmpty()) {
            CodegenImplObjectStrict.append(lines, String.format("%s obj = {{newInst}};", CodegenImplNative.getTypeName(desc.clazz)));
            for (Binding field : desc.fields) {
                if (field.fromNames.length == 0) continue;
                CodegenImplObjectStrict.append(lines, String.format("obj.%s = _%s_;", field.field.getName(), field.name));
            }
            for (Binding setter : desc.setters) {
                CodegenImplObjectStrict.append(lines, String.format("obj.%s(_%s_);", setter.method.getName(), setter.name));
            }
        }
        CodegenImplObjectHash.appendWrappers(desc.bindingTypeWrappers, lines);
        CodegenImplObjectStrict.append(lines, "return obj;");
        return lines.toString().replace("{{clazz}}", desc.clazz.getCanonicalName()).replace("{{newInst}}", CodegenImplObjectHash.genNewInstCode(desc.clazz, desc.ctor));
    }

    private static void appendSetExtraToKeyValueTypeWrappers(StringBuilder lines, ClassDescriptor desc) {
        CodegenImplObjectStrict.append(lines, "java.util.Iterator extraIter = extra.entrySet().iterator();");
        CodegenImplObjectStrict.append(lines, "while(extraIter.hasNext()) {");
        for (Method wrapper : desc.keyValueTypeWrappers) {
            CodegenImplObjectStrict.append(lines, "java.util.Map.Entry entry = (java.util.Map.Entry)extraIter.next();");
            CodegenImplObjectStrict.append(lines, "String key = entry.getKey().toString();");
            CodegenImplObjectStrict.append(lines, "com.jsoniter.any.Any value = (com.jsoniter.any.Any)entry.getValue();");
            CodegenImplObjectStrict.append(lines, String.format("obj.%s(key, value.object());", wrapper.getName()));
        }
        CodegenImplObjectStrict.append(lines, "}");
    }

    private static void appendSetExtraProperteis(StringBuilder lines, ClassDescriptor desc) {
        Binding onExtraProperties = desc.onExtraProperties;
        if (GenericsHelper.isSameClass(onExtraProperties.valueType, Map.class)) {
            if (onExtraProperties.field != null) {
                CodegenImplObjectStrict.append(lines, String.format("obj.%s = extra;", onExtraProperties.field.getName()));
            } else {
                CodegenImplObjectStrict.append(lines, String.format("obj.%s(extra);", onExtraProperties.method.getName()));
            }
            return;
        }
        throw new JsonException("extra properties can only be Map");
    }

    private static boolean hasAnythingToBindFrom(List<Binding> allBindings) {
        for (Binding binding : allBindings) {
            if (binding.fromNames.length <= 0) continue;
            return true;
        }
        return false;
    }

    private static int assignMaskForRequiredProperties(List<Binding> allBindings) {
        int requiredIdx = 0;
        for (Binding binding : allBindings) {
            if (!binding.asMissingWhenNotPresent) continue;
            binding.mask = 1L << requiredIdx;
            ++requiredIdx;
        }
        if (requiredIdx > 63) {
            throw new JsonException("too many required properties to track");
        }
        return requiredIdx;
    }

    private static String updateBindingSetOp(String rendered, Binding binding) {
        if (binding.fromNames.length == 0) {
            return rendered;
        }
        String marker;
        int start;
        while ((start = rendered.indexOf(marker = "_" + binding.name + "_")) != -1) {
            int middle = rendered.indexOf(61, start);
            if (middle == -1) {
                throw new JsonException("can not find = in: " + rendered + " ,at " + start);
            }
            ++middle;
            int end = rendered.indexOf(59, start);
            if (end == -1) {
                throw new JsonException("can not find ; in: " + rendered + " ,at " + start);
            }
            String op = rendered.substring(middle, end);
            if (binding.field != null) {
                if (binding.valueCanReuse) {
                    rendered = String.format("%scom.jsoniter.CodegenAccess.setExistingObject(iter, obj.%s);obj.%s=%s%s", rendered.substring(0, start), binding.field.getName(), binding.field.getName(), op, rendered.substring(end));
                    continue;
                }
                rendered = String.format("%sobj.%s=%s%s", rendered.substring(0, start), binding.field.getName(), op, rendered.substring(end));
                continue;
            }
            rendered = String.format("%sobj.%s(%s)%s", rendered.substring(0, start), binding.method.getName(), op, rendered.substring(end));
        }
        return rendered;
    }

    private static void appendMissingRequiredProperties(StringBuilder lines, ClassDescriptor desc) {
        CodegenImplObjectStrict.append(lines, "java.util.List missingFields = new java.util.ArrayList();");
        for (Binding binding : desc.allDecoderBindings()) {
            if (!binding.asMissingWhenNotPresent) continue;
            long mask = binding.mask;
            CodegenImplObjectStrict.append(lines, String.format("com.jsoniter.CodegenAccess.addMissingField(missingFields, tracker, %sL, \"%s\");", mask, binding.name));
        }
        if (desc.onMissingProperties == null || !desc.ctor.parameters.isEmpty()) {
            CodegenImplObjectStrict.append(lines, "throw new com.jsoniter.spi.JsonException(\"missing required properties: \" + missingFields);");
        } else if (desc.onMissingProperties.field != null) {
            CodegenImplObjectStrict.append(lines, String.format("obj.%s = missingFields;", desc.onMissingProperties.field.getName()));
        } else {
            CodegenImplObjectStrict.append(lines, String.format("obj.%s(missingFields);", desc.onMissingProperties.method.getName()));
        }
    }

    private static void appendOnUnknownField(StringBuilder lines, ClassDescriptor desc) {
        if (desc.asExtraForUnknownProperties && desc.onExtraProperties == null) {
            CodegenImplObjectStrict.append(lines, "throw new com.jsoniter.spi.JsonException('extra property: ' + field.toString());".replace('\'', '\"'));
        } else if (desc.asExtraForUnknownProperties || !desc.keyValueTypeWrappers.isEmpty()) {
            CodegenImplObjectStrict.append(lines, "if (extra == null) { extra = new java.util.HashMap(); }");
            CodegenImplObjectStrict.append(lines, "extra.put(field.toString(), iter.readAny());");
        } else {
            CodegenImplObjectStrict.append(lines, "iter.skip();");
        }
    }

    private static Map<Integer, Object> buildTriTree(List<Binding> allBindings) {
        HashMap<Integer, Object> trieTree = new HashMap<Integer, Object>();
        for (Binding field : allBindings) {
            for (String fromName : field.fromNames) {
                byte[] fromNameBytes = fromName.getBytes();
                HashMap<Byte, Binding> current = (HashMap<Byte, Binding>)trieTree.get(fromNameBytes.length);
                if (current == null) {
                    current = new HashMap<Byte, Binding>();
                    trieTree.put(fromNameBytes.length, current);
                }
                for (int i = 0; i < fromNameBytes.length - 1; ++i) {
                    byte b = fromNameBytes[i];
                    HashMap next = (HashMap)current.get(b);
                    if (next == null) {
                        next = new HashMap();
                        current.put(b, (Binding)((Object)next));
                    }
                    current = next;
                }
                current.put(fromNameBytes[fromNameBytes.length - 1], field);
            }
        }
        return trieTree;
    }

    private static String renderTriTree(Map<Integer, Object> trieTree) {
        StringBuilder switchBody = new StringBuilder();
        for (Map.Entry<Integer, Object> entry : trieTree.entrySet()) {
            Integer len = entry.getKey();
            CodegenImplObjectStrict.append(switchBody, "case " + len + ": ");
            Map current = (Map)entry.getValue();
            CodegenImplObjectStrict.addFieldDispatch(switchBody, len, 0, current, new ArrayList<Byte>());
            CodegenImplObjectStrict.append(switchBody, "break;");
        }
        return switchBody.toString();
    }

    private static void addFieldDispatch(StringBuilder lines, int len, int i, Map<Byte, Object> current, List<Byte> bytesToCompare) {
        for (Map.Entry<Byte, Object> entry : current.entrySet()) {
            Byte b = entry.getKey();
            if (i == len - 1) {
                CodegenImplObjectStrict.append(lines, "if (");
                for (int j = 0; j < bytesToCompare.size(); ++j) {
                    Byte a = bytesToCompare.get(j);
                    CodegenImplObjectStrict.append(lines, String.format("field.at(%d)==%s && ", i - bytesToCompare.size() + j, a));
                }
                CodegenImplObjectStrict.append(lines, String.format("field.at(%d)==%s", i, b));
                CodegenImplObjectStrict.append(lines, ") {");
                Binding field = (Binding)entry.getValue();
                if (field.asExtraWhenPresent) {
                    CodegenImplObjectStrict.append(lines, String.format("throw new com.jsoniter.spi.JsonException('extra property: %s');".replace('\'', '\"'), field.name));
                } else if (field.shouldSkip) {
                    CodegenImplObjectStrict.append(lines, "iter.skip();");
                    CodegenImplObjectStrict.append(lines, "continue;");
                } else {
                    CodegenImplObjectStrict.append(lines, String.format("_%s_ = %s;", field.name, CodegenImplNative.genField(field)));
                    if (field.asMissingWhenNotPresent) {
                        CodegenImplObjectStrict.append(lines, "tracker = tracker | " + field.mask + "L;");
                    }
                    CodegenImplObjectStrict.append(lines, "continue;");
                }
                CodegenImplObjectStrict.append(lines, "}");
                continue;
            }
            Map next = (Map)entry.getValue();
            if (next.size() == 1) {
                ArrayList<Byte> nextBytesToCompare = new ArrayList<Byte>(bytesToCompare);
                nextBytesToCompare.add(b);
                CodegenImplObjectStrict.addFieldDispatch(lines, len, i + 1, next, nextBytesToCompare);
                continue;
            }
            CodegenImplObjectStrict.append(lines, "if (");
            for (int j = 0; j < bytesToCompare.size(); ++j) {
                Byte a = bytesToCompare.get(j);
                CodegenImplObjectStrict.append(lines, String.format("field.at(%d)==%s && ", i - bytesToCompare.size() + j, a));
            }
            CodegenImplObjectStrict.append(lines, String.format("field.at(%d)==%s", i, b));
            CodegenImplObjectStrict.append(lines, ") {");
            CodegenImplObjectStrict.addFieldDispatch(lines, len, i + 1, next, new ArrayList<Byte>());
            CodegenImplObjectStrict.append(lines, "}");
        }
    }

    public static String genObjectUsingSkip(Class clazz, ConstructorDescriptor ctor) {
        StringBuilder lines = new StringBuilder();
        CodegenImplObjectStrict.append(lines, "if (iter.readNull()) { return null; }");
        CodegenImplObjectStrict.append(lines, "{{clazz}} obj = {{newInst}};");
        CodegenImplObjectStrict.append(lines, "iter.skip();");
        CodegenImplObjectStrict.append(lines, "return obj;");
        return lines.toString().replace("{{clazz}}", clazz.getCanonicalName()).replace("{{newInst}}", CodegenImplObjectHash.genNewInstCode(clazz, ctor));
    }

    static void append(StringBuilder lines, String str) {
        lines.append(str);
        lines.append("\n");
    }
}

