/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.Codegen;
import com.jsoniter.JsonIterator;
import com.jsoniter.any.Any;
import com.jsoniter.spi.Binding;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

class CodegenImplNative {
    static final Map<String, String> NATIVE_READS = new HashMap<String, String>(){
        {
            this.put("float", "iter.readFloat()");
            this.put("double", "iter.readDouble()");
            this.put("boolean", "iter.readBoolean()");
            this.put("byte", "iter.readShort()");
            this.put("short", "iter.readShort()");
            this.put("int", "iter.readInt()");
            this.put("char", "iter.readInt()");
            this.put("long", "iter.readLong()");
            this.put(Float.class.getName(), "(iter.readNull() ? null : java.lang.Float.valueOf(iter.readFloat()))");
            this.put(Double.class.getName(), "(iter.readNull() ? null : java.lang.Double.valueOf(iter.readDouble()))");
            this.put(Boolean.class.getName(), "(iter.readNull() ? null : java.lang.Boolean.valueOf(iter.readBoolean()))");
            this.put(Byte.class.getName(), "(iter.readNull() ? null : java.lang.Byte.valueOf((byte)iter.readShort()))");
            this.put(Character.class.getName(), "(iter.readNull() ? null : java.lang.Character.valueOf((char)iter.readShort()))");
            this.put(Short.class.getName(), "(iter.readNull() ? null : java.lang.Short.valueOf(iter.readShort()))");
            this.put(Integer.class.getName(), "(iter.readNull() ? null : java.lang.Integer.valueOf(iter.readInt()))");
            this.put(Long.class.getName(), "(iter.readNull() ? null : java.lang.Long.valueOf(iter.readLong()))");
            this.put(BigDecimal.class.getName(), "iter.readBigDecimal()");
            this.put(BigInteger.class.getName(), "iter.readBigInteger()");
            this.put(String.class.getName(), "iter.readString()");
            this.put(Object.class.getName(), "iter.read()");
            this.put(Any.class.getName(), "iter.readAny()");
        }
    };
    static final Map<Class, Decoder> NATIVE_DECODERS = new HashMap<Class, Decoder>(){
        {
            this.put(Float.TYPE, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return Float.valueOf(iter.readFloat());
                }
            });
            this.put(Float.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readNull() ? null : Float.valueOf(iter.readFloat());
                }
            });
            this.put(Double.TYPE, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readDouble();
                }
            });
            this.put(Double.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readNull() ? null : Double.valueOf(iter.readDouble());
                }
            });
            this.put(Boolean.TYPE, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readBoolean();
                }
            });
            this.put(Boolean.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readNull() ? null : Boolean.valueOf(iter.readBoolean());
                }
            });
            this.put(Byte.TYPE, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return (byte)iter.readShort();
                }
            });
            this.put(Byte.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readNull() ? null : Byte.valueOf((byte)iter.readShort());
                }
            });
            this.put(Short.TYPE, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readShort();
                }
            });
            this.put(Short.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readNull() ? null : Short.valueOf(iter.readShort());
                }
            });
            this.put(Integer.TYPE, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readInt();
                }
            });
            this.put(Integer.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readNull() ? null : Integer.valueOf(iter.readInt());
                }
            });
            this.put(Character.TYPE, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return Character.valueOf((char)iter.readInt());
                }
            });
            this.put(Character.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readNull() ? null : Character.valueOf((char)iter.readInt());
                }
            });
            this.put(Long.TYPE, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readLong();
                }
            });
            this.put(Long.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readNull() ? null : Long.valueOf(iter.readLong());
                }
            });
            this.put(BigDecimal.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readBigDecimal();
                }
            });
            this.put(BigInteger.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readBigInteger();
                }
            });
            this.put(String.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readString();
                }
            });
            this.put(Object.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.read();
                }
            });
            this.put(Any.class, new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    return iter.readAny();
                }
            });
        }
    };

    CodegenImplNative() {
    }

    public static String genReadOp(Type type) {
        String cacheKey = TypeLiteral.create(type).getDecoderCacheKey();
        return String.format("(%s)%s", CodegenImplNative.getTypeName(type), CodegenImplNative.genReadOp(cacheKey, type));
    }

    public static String getTypeName(Type fieldType) {
        if (fieldType instanceof Class) {
            Class clazz = (Class)fieldType;
            return clazz.getCanonicalName();
        }
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)fieldType;
            Class clazz = (Class)pType.getRawType();
            return clazz.getCanonicalName();
        }
        if (fieldType instanceof WildcardType) {
            return Object.class.getCanonicalName();
        }
        throw new JsonException("unsupported type: " + fieldType);
    }

    static String genField(Binding field) {
        String fieldCacheKey = field.decoderCacheKey();
        Type fieldType = field.valueType;
        return String.format("(%s)%s", CodegenImplNative.getTypeName(fieldType), CodegenImplNative.genReadOp(fieldCacheKey, fieldType));
    }

    private static String genReadOp(String cacheKey, Type valueType) {
        Decoder decoder = JsoniterSpi.getDecoder(cacheKey);
        if (decoder == null && (decoder = JsoniterSpi.getDecoder(cacheKey = TypeLiteral.create(valueType).getDecoderCacheKey())) == null) {
            if (valueType instanceof Class) {
                Class clazz = (Class)valueType;
                String nativeRead = NATIVE_READS.get(clazz.getCanonicalName());
                if (nativeRead != null) {
                    return nativeRead;
                }
            } else if (valueType instanceof WildcardType) {
                return NATIVE_READS.get(Object.class.getCanonicalName());
            }
            Codegen.getDecoder(cacheKey, valueType);
            if (Codegen.canStaticAccess(cacheKey)) {
                return String.format("%s.decode_(iter)", cacheKey);
            }
            return String.format("com.jsoniter.CodegenAccess.read(\"%s\", iter)", cacheKey);
        }
        if (valueType == Boolean.TYPE) {
            if (!(decoder instanceof Decoder.BooleanDecoder)) {
                throw new JsonException("decoder for " + cacheKey + "must implement Decoder.BooleanDecoder");
            }
            return String.format("com.jsoniter.CodegenAccess.readBoolean(\"%s\", iter)", cacheKey);
        }
        if (valueType == Byte.TYPE) {
            if (!(decoder instanceof Decoder.ShortDecoder)) {
                throw new JsonException("decoder for " + cacheKey + "must implement Decoder.ShortDecoder");
            }
            return String.format("com.jsoniter.CodegenAccess.readShort(\"%s\", iter)", cacheKey);
        }
        if (valueType == Short.TYPE) {
            if (!(decoder instanceof Decoder.ShortDecoder)) {
                throw new JsonException("decoder for " + cacheKey + "must implement Decoder.ShortDecoder");
            }
            return String.format("com.jsoniter.CodegenAccess.readShort(\"%s\", iter)", cacheKey);
        }
        if (valueType == Character.TYPE) {
            if (!(decoder instanceof Decoder.IntDecoder)) {
                throw new JsonException("decoder for " + cacheKey + "must implement Decoder.IntDecoder");
            }
            return String.format("com.jsoniter.CodegenAccess.readInt(\"%s\", iter)", cacheKey);
        }
        if (valueType == Integer.TYPE) {
            if (!(decoder instanceof Decoder.IntDecoder)) {
                throw new JsonException("decoder for " + cacheKey + "must implement Decoder.IntDecoder");
            }
            return String.format("com.jsoniter.CodegenAccess.readInt(\"%s\", iter)", cacheKey);
        }
        if (valueType == Long.TYPE) {
            if (!(decoder instanceof Decoder.LongDecoder)) {
                throw new JsonException("decoder for " + cacheKey + "must implement Decoder.LongDecoder");
            }
            return String.format("com.jsoniter.CodegenAccess.readLong(\"%s\", iter)", cacheKey);
        }
        if (valueType == Float.TYPE) {
            if (!(decoder instanceof Decoder.FloatDecoder)) {
                throw new JsonException("decoder for " + cacheKey + "must implement Decoder.FloatDecoder");
            }
            return String.format("com.jsoniter.CodegenAccess.readFloat(\"%s\", iter)", cacheKey);
        }
        if (valueType == Double.TYPE) {
            if (!(decoder instanceof Decoder.DoubleDecoder)) {
                throw new JsonException("decoder for " + cacheKey + "must implement Decoder.DoubleDecoder");
            }
            return String.format("com.jsoniter.CodegenAccess.readDouble(\"%s\", iter)", cacheKey);
        }
        return String.format("com.jsoniter.CodegenAccess.read(\"%s\", iter)", cacheKey);
    }
}

