/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.jgettext;

import org.fedorahosted.tennera.jgettext.Message;

public class MessageHashKey {
    private final String msgctxt;
    private final String msgid;
    private final int hashcode;

    public MessageHashKey(Message message) {
        this(message.getMsgctxt(), message.getMsgid());
    }

    public MessageHashKey(String msgctxt, String msgid) {
        this.msgctxt = msgctxt;
        this.msgid = msgid;
        this.hashcode = this.generateHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageHashKey that = (MessageHashKey)o;
        return !(this.msgctxt == null ? that.msgctxt != null : !this.msgctxt.equals(that.msgctxt)) && this.msgid.equals(that.msgid);
    }

    public int hashCode() {
        return this.hashcode;
    }

    private int generateHashCode() {
        int result = this.msgctxt != null ? this.msgctxt.hashCode() : 0;
        result = 31 * result + this.msgid.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MessageHashKey(msgctxt ");
        if (this.msgctxt == null) {
            sb.append("null");
        } else {
            sb.append('\"');
            sb.append(this.msgctxt);
            sb.append('\"');
        }
        sb.append(", msgid ");
        if (this.msgid == null) {
            sb.append("null");
        } else {
            sb.append('\"');
            sb.append(this.msgid);
            sb.append('\"');
        }
        sb.append(")");
        return sb.toString();
    }
}

