/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.jgettext;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.fedorahosted.tennera.jgettext.HeaderFields;
import org.fedorahosted.tennera.jgettext.Message;

public class HeaderUtil {
    public static Message generateDefaultHeader() {
        return HeaderUtil.generateDefaultHeader(new Date());
    }

    public static Message generateDefaultHeader(Date potCreationDate) {
        HeaderValues param = new HeaderValues();
        param.projectIdVersion = "PACKAGE VERSION";
        param.reportMsgidBugsTo = "";
        param.potCreationDate = potCreationDate;
        param.poRevisionDate = "YEAR-MO-DA HO:MI+ZONE";
        param.lastTranslator = "FULL NAME <EMAIL@ADDRESS>";
        param.languageTeam = "LANGUAGE <LL@li.org>";
        param.charset = "UTF-8";
        param.comments.add("SOME DESCRIPTIVE TITLE.");
        param.comments.add("Copyright (C) YEAR THE PACKAGE'S COPYRIGHT HOLDER");
        param.comments.add("This file is distributed under the same license as the PACKAGE package.");
        param.comments.add("FIRST AUTHOR <EMAIL@ADDRESS>, YEAR.");
        param.comments.add("");
        return HeaderUtil.generateHeader(param);
    }

    private static Message generateHeader(HeaderValues param) {
        HeaderFields header = new HeaderFields();
        HeaderUtil.setValues(header, param);
        Message headerMsg = header.unwrap();
        for (String comment : param.comments) {
            headerMsg.addComment(comment);
        }
        return headerMsg;
    }

    private static void setValues(HeaderFields header, HeaderValues param) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mmZ");
        header.setValue("Project-Id-Version", param.projectIdVersion);
        header.setValue("Report-Msgid-Bugs-To", param.reportMsgidBugsTo);
        header.setValue("POT-Creation-Date", dateFormat.format(param.potCreationDate));
        header.setValue("PO-Revision-Date", param.poRevisionDate);
        header.setValue("Last-Translator", param.lastTranslator);
        header.setValue("Language-Team", param.languageTeam);
        header.setValue("MIME-Version", "1.0");
        header.setValue("Content-Type", "text/plain; charset=" + param.charset);
        header.setValue("Content-Transfer-Encoding", "8bit");
    }

    private static class HeaderValues {
        public String projectIdVersion;
        public String reportMsgidBugsTo;
        public Date potCreationDate;
        public String poRevisionDate;
        public String lastTranslator;
        public String languageTeam;
        public String charset;
        public List<String> comments = new ArrayList<String>();

        public HeaderValues() {
        }

        public HeaderValues(String projectIdVersion, String reportMsgidBugsTo, Date potCreationDate, String poRevisionDate, String lastTranslator, String languageTeam, String charset, List<String> comments) {
            this.projectIdVersion = projectIdVersion;
            this.reportMsgidBugsTo = reportMsgidBugsTo;
            this.potCreationDate = potCreationDate;
            this.poRevisionDate = poRevisionDate;
            this.lastTranslator = lastTranslator;
            this.languageTeam = languageTeam;
            this.charset = charset;
            this.comments = comments;
        }
    }
}

