/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.ResponseList;
import facebook4j.Subscriber;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.json.UserJSONImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SubscriberJSONImpl
extends UserJSONImpl
implements Subscriber,
Serializable {
    private static final long serialVersionUID = 1308800643285534026L;

    SubscriberJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
    }

    SubscriberJSONImpl(JSONObject json) throws FacebookException {
        super(json);
    }

    static ResponseList<Subscriber> createSubscriberList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Subscriber> subscribers = new ResponseListImpl<Subscriber>(size, json, new Subscriber[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject subscriberJSONObject = list.getJSONObject(i);
                SubscriberJSONImpl subscriber = new SubscriberJSONImpl(subscriberJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(subscriber, subscriberJSONObject);
                }
                subscribers.add(subscriber);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(subscribers, list);
            }
            return subscribers;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String toString() {
        return "SubscriberJSONImpl extends " + super.toString();
    }
}

